"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Container = _styledComponents.default.div`
  border-bottom: ${props => props.theme.eui.euiBorderThin};
  background-color: ${props => props.theme.eui.euiPageBackgroundColor};

  @media (max-width: 767px) {
    .euiFlexItem {
      margin-bottom: 0 !important;
    }
  }
`;
const Wrapper = _styledComponents.default.div`
  max-width: ${props => props.maxWidth || 1200}px;
  margin-left: auto;
  margin-right: auto;
  padding-top: ${props => props.theme.eui.euiSizeXL};
  padding-left: ${props => props.theme.eui.euiSizeM};
  padding-right: ${props => props.theme.eui.euiSizeM};
`;
const Tabs = (0, _styledComponents.default)(_eui.EuiTabs)`
  top: 1px;
  &:before {
    height: 0px;
  }
`;
const HeaderColumns = /*#__PURE__*/(0, _react.memo)(({
  leftColumn,
  rightColumn,
  rightColumnGrow
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center"
}, leftColumn ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, leftColumn) : null, rightColumn ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: rightColumnGrow
}, rightColumn) : null));
const Header = ({
  leftColumn,
  rightColumn,
  rightColumnGrow,
  topContent,
  tabs,
  maxWidth,
  tabsClassName,
  'data-test-subj': dataTestSubj
}) => /*#__PURE__*/_react.default.createElement(Container, {
  "data-test-subj": dataTestSubj
}, /*#__PURE__*/_react.default.createElement(Wrapper, {
  maxWidth: maxWidth
}, topContent, /*#__PURE__*/_react.default.createElement(HeaderColumns, {
  leftColumn: leftColumn,
  rightColumn: rightColumn,
  rightColumnGrow: rightColumnGrow
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, tabs ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(Tabs, {
  className: tabsClassName
}, tabs.map((props, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, (0, _extends2.default)({}, props, {
  key: `${props.id}-${index}`
}), props.name)))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "l"
})))));
exports.Header = Header;