"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AzureArmTemplateGuide = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../hooks");
var _hooks2 = require("../agent_enrollment_flyout/hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const azureResourceManagerLink = 'https://azure.microsoft.com/en-us/get-started/azure-portal/resource-manager';
const AzureArmTemplateGuide = ({
  azureAccountType,
  agentPolicy,
  enrollmentToken = ''
}) => {
  const {
    agentPolicyWithPackagePolicies
  } = (0, _hooks2.useAgentPolicyWithPackagePolicies)(agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.id);
  const {
    fleetServerHosts
  } = (0, _hooks.useFleetServerHostsForPolicy)(agentPolicyWithPackagePolicies);
  const fleetServerHost = fleetServerHosts[0];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.azureArmTemplate.guide.description",
    defaultMessage: "An Azure Resource Manager (ARM) Template will create all the necessary resources to evaluate the security posture of your Azure organization. Follow the steps below to launch the ARM template. Learn more about {learnMore}.",
    values: {
      learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: azureResourceManagerLink,
        target: "_blank",
        rel: "noopener nofollow noreferrer",
        "data-test-subj": "azure-resource-manager-link"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.azureArmTemplate.guide.learnMoreLinkText",
        defaultMessage: "Azure Resource Manager"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("ol", null, azureAccountType === 'organization-account' ? /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.azureArmTemplate.guide.steps.organizationLogin",
    defaultMessage: "Log into your Azure Portal"
  })) : /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.azureArmTemplate.guide.steps.login",
    defaultMessage: "Log into your Azure Portal"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.azureArmTemplate.guide.steps.launch",
    defaultMessage: "Click the Launch ARM Template button below."
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.azureArmTemplate.guide.steps.fillForm",
    defaultMessage: "Use the provided fields below to fill the instance details section of the ARM Template:"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: [{
      title: 'Fleet URL',
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        isCopyable: true,
        paddingSize: "m"
      }, fleetServerHost)
    }, {
      title: 'Enrollment Token',
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        isCopyable: true,
        paddingSize: "m"
      }, enrollmentToken)
    }]
  })))));
};
exports.AzureArmTemplateGuide = AzureArmTemplateGuide;