"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddAgentHelpPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styledComponents = require("styled-components");
var _constants = require("../constants");
var _hooks = require("../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddAgentHelpPopover = ({
  button,
  isOpen,
  offset,
  closePopover
}) => {
  const {
    docLinks,
    uiSettings,
    storage
  } = (0, _hooks.useStartServices)();
  const theme = (0, _styledComponents.useTheme)();
  const optionalProps = {};
  const hideAddAgentTour = (0, _react.useMemo)(() => {
    var _storage$get;
    return uiSettings.get('hideAnnouncements', false) || ((_storage$get = storage.get(_constants.TOUR_STORAGE_KEYS.ADD_AGENT_POPOVER)) === null || _storage$get === void 0 ? void 0 : _storage$get.active) === false;
  }, [storage, uiSettings]);
  const onFinish = () => {
    storage.set(_constants.TOUR_STORAGE_KEYS.ADD_AGENT_POPOVER, {
      active: false
    });
  };
  if (offset !== undefined) {
    optionalProps.offset = offset; // offset being present in props sets it to 0 so only add if specified
  }
  return hideAddAgentTour ? button : /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, (0, _extends2.default)({}, optionalProps, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      style: {
        width: 302
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.addAgentHelpPopover.popoverBody",
      defaultMessage: "For integrations to work successfully, add {elasticAgent} to your host to collect data and send it to Elastic Stack. {learnMoreLink}",
      values: {
        elasticAgent: /*#__PURE__*/_react.default.createElement("strong", null, "Elastic Agent"),
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          external: true,
          href: docLinks.links.fleet.elasticAgent
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.addAgentHelpPopover.documentationLink",
          defaultMessage: "Learn more about Elastic Agent."
        }))
      }
    })),
    zIndex: theme.eui.euiZLevel1 - 1 // put popover behind any modals that happen to be open
    ,
    isStepOpen: isOpen,
    minWidth: 300,
    onFinish: onFinish,
    step: 1,
    stepsTotal: 1,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.addAgentHelpPopover.title",
      defaultMessage: "Don't forget to add the agent to your host"
    }),
    anchorPosition: "downCenter",
    subtitle: null,
    "data-test-subj": "addAgentHelpPopover",
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => {
        onFinish();
        closePopover();
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.addAgentHelpPopover.footActionButton",
      defaultMessage: "Got it"
    }))
  }), button);
};
exports.AddAgentHelpPopover = AddAgentHelpPopover;