"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EPMApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _constants = require("../../constants");
var _hooks = require("../../hooks");
var _home = require("./screens/home");
var _detail = require("./screens/detail");
var _policy = require("./screens/policy");
var _custom_languages_overview = require("./screens/detail/custom_languages_overview");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EPMApp = () => {
  (0, _hooks.useBreadcrumbs)('integrations');
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.INTEGRATIONS_ROUTING_PATHS.integration_policy_edit
  }, /*#__PURE__*/_react.default.createElement(_policy.Policy, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.INTEGRATIONS_ROUTING_PATHS.integration_details
  }, /*#__PURE__*/_react.default.createElement(_hooks.IntegrationsStateContextProvider, null, /*#__PURE__*/_react.default.createElement(_detail.Detail, null))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.INTEGRATIONS_ROUTING_PATHS.integration_details_language_clients
  }, /*#__PURE__*/_react.default.createElement(_hooks.IntegrationsStateContextProvider, null, /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null)
  }, /*#__PURE__*/_react.default.createElement(_custom_languages_overview.CustomLanguagesOverview, null)))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.INTEGRATIONS_ROUTING_PATHS.integrations
  }, /*#__PURE__*/_react.default.createElement(_home.EPMHomePage, null)));
};
exports.EPMApp = EPMApp;