"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetsFacetGroup = AssetsFacetGroup;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../types");
var _constants = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FirstHeaderRow = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  padding: 0 0 ${props => props.theme.eui.euiSizeM} 0;
`;
const HeaderRow = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  padding: ${props => props.theme.eui.euiSizeM} 0;
`;
const FacetGroup = (0, _styledComponents.default)(_eui.EuiFacetGroup)`
  flex-grow: 0;
`;
const FacetButton = (0, _styledComponents.default)(_eui.EuiFacetButton)`
  &&& {
    .euiFacetButton__icon,
    .euiFacetButton__quantity {
      opacity: 1;
    }
    .euiFacetButton__text {
      color: ${props => props.theme.eui.euiTextColor};
    }
  }
`;
function AssetsFacetGroup({
  assets
}) {
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, (0, _types.entries)(assets).map(([service, typeToParts], index) => {
    const Header = index === 0 ? FirstHeaderRow : HeaderRow;
    // filter out assets we are not going to display
    const filteredTypes = (0, _types.entries)(typeToParts).reduce((acc, [asset, value]) => {
      if (_constants.DisplayedAssets[service].includes(asset)) acc[asset] = value;
      return acc;
    }, {});
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: service
    }, /*#__PURE__*/_react.default.createElement(Header, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _constants.ServiceIcons[service]
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      key: service,
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.assetGroupTitle",
      defaultMessage: "{assetType} assets",
      values: {
        assetType: _constants.ServiceTitleMap[service]
      }
    })))))), /*#__PURE__*/_react.default.createElement(FacetGroup, null, (0, _types.entries)(filteredTypes).map(([_type, parts]) => {
      const type = _type;
      // only kibana assets have icons
      const iconType = type in _constants.AssetIcons && _constants.AssetIcons[type];
      const iconNode = iconType ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: iconType,
        size: "s"
      }) : '';
      return /*#__PURE__*/_react.default.createElement(FacetButton, {
        key: type,
        quantity: parts.length,
        icon: iconNode,
        isDisabled: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, _constants.AssetTitleMap[type]));
    })));
  }));
}