"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationsAppContext = exports.AppRoutes = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _reactQuery = require("@tanstack/react-query");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _common = require("@kbn/kibana-react-plugin/common");
var _hooks = require("../../hooks");
var _components = require("../fleet/components");
var _hooks2 = require("./hooks");
var _constants = require("./constants");
var _epm = require("./sections/epm");
var _header = require("./components/header");
var _components2 = require("./components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const queryClient = new _reactQuery.QueryClient();
const EmptyContext = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);

/**
 * Fleet Application context all the way down to the Router, but with no permissions or setup checks
 * and no routes defined
 */
const IntegrationsAppContext = exports.IntegrationsAppContext = /*#__PURE__*/(0, _react.memo)(({
  children,
  startServices,
  config,
  history,
  kibanaVersion,
  extensions,
  setHeaderActionMenu,
  theme$,
  fleetStatus
}) => {
  var _startServices$cloud;
  const theme = (0, _useObservable.default)(theme$);
  const isDarkMode = theme && theme.darkMode;
  const CloudContext = ((_startServices$cloud = startServices.cloud) === null || _startServices$cloud === void 0 ? void 0 : _startServices$cloud.CloudContextProvider) || EmptyContext;
  return /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: startServices.application
    }
  }, /*#__PURE__*/_react.default.createElement(startServices.i18n.Context, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...startServices
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_hooks.ConfigContext.Provider, {
    value: config
  }, /*#__PURE__*/_react.default.createElement(_hooks.KibanaVersionContext.Provider, {
    value: kibanaVersion
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: isDarkMode
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false
  }), /*#__PURE__*/_react.default.createElement(_hooks2.UIExtensionsContext.Provider, {
    value: extensions
  }, /*#__PURE__*/_react.default.createElement(_hooks.FleetStatusProvider, {
    defaultFleetStatus: fleetStatus
  }, /*#__PURE__*/_react.default.createElement(startServices.customIntegrations.ContextProvider, null, /*#__PURE__*/_react.default.createElement(CloudContext, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_hooks2.AgentPolicyContextProvider, null, /*#__PURE__*/_react.default.createElement(_hooks2.PackageInstallProvider, {
    notifications: startServices.notifications,
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_hooks2.FlyoutContextProvider, null, /*#__PURE__*/_react.default.createElement(_header.IntegrationsHeader, {
    setHeaderActionMenu,
    theme$
  }), children)))))))))))))))));
});
const AppRoutes = exports.AppRoutes = /*#__PURE__*/(0, _react.memo)(() => {
  var _fleetStatus$missingR;
  const flyoutContext = (0, _hooks2.useFlyoutContext)();
  const fleetStatus = (0, _hooks.useFleetStatus)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.INTEGRATIONS_ROUTING_PATHS.integrations
  }, /*#__PURE__*/_react.default.createElement(_epm.EPMApp, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    render: ({
      location
    }) => {
      // BWC < 7.15 Fleet was using a hash router: redirect old routes using hash
      const shouldRedirectHash = location.pathname === '' && location.hash.length > 0;
      if (!shouldRedirectHash) {
        return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
          to: _constants.pagePathGetters.integrations_all({})[1]
        });
      }
      const pathname = location.hash.replace(/^#/, '');
      return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
        to: {
          ...location,
          pathname,
          hash: undefined
        }
      });
    }
  })), flyoutContext.isEnrollmentFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components2.AgentEnrollmentFlyout, {
    defaultMode: fleetStatus.isReady && (_fleetStatus$missingR = fleetStatus.missingRequirements) !== null && _fleetStatus$missingR !== void 0 && _fleetStatus$missingR.includes('fleet_server') ? 'managed' : 'standalone',
    isIntegrationFlow: true,
    onClose: () => flyoutContext.closeEnrollmentFlyout()
  })), flyoutContext.isFleetServerFlyoutOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components.FleetServerFlyout, {
    onClose: () => flyoutContext.closeFleetServerFlyout()
  })));
});