"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetServerHostsFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _multi_row_input = require("../multi_row_input");
var _hooks = require("../../../../hooks");
var _constants = require("../../constants");
var _form = require("../form");
var _use_fleet_server_host_form = require("./use_fleet_server_host_form");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FleetServerHostsFlyout = ({
  onClose,
  fleetServerHost,
  defaultFleetServerHost,
  proxies
}) => {
  const {
    docLinks,
    cloud
  } = (0, _hooks.useStartServices)();
  const form = (0, _use_fleet_server_host_form.useFleetServerHostsForm)(fleetServerHost, onClose, defaultFleetServerHost);
  const {
    inputs
  } = form;
  const proxiesOptions = (0, _react.useMemo)(() => proxies.map(proxy => ({
    value: proxy.id,
    label: proxy.name
  })), [proxies]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    maxWidth: _constants.FLYOUT_MAX_WIDTH,
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, fleetServerHost ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.editTitle",
    defaultMessage: "Edit Fleet Server"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.addTitle",
    defaultMessage: "Add Fleet Server"
  }))), !fleetServerHost && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.serverlessInfoText",
    defaultMessage: "You may create another Fleet Server definition reachable via a proxy. In context of the serverless project, Fleet Service is managed by Elastic. Creation of a new one is therefore not permitted."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, fleetServerHost && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    color: "warning",
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.warningCalloutTitle",
      defaultMessage: "Changing these settings can break your agent connections"
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.warningCalloutDescription",
    defaultMessage: "Invalid settings can break the connection between Elastic Agent and Fleet Server. If this happens, you will need to re-enroll your agents."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: form.submit
  }, /*#__PURE__*/_react.default.createElement(_form.TextInput, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.nameInputLabel",
      defaultMessage: "Name"
    }),
    inputProps: inputs.nameInput,
    dataTestSubj: "fleetServerHostsFlyout.nameInput",
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsFlyout.nameInputPlaceholder', {
      defaultMessage: 'Specify name'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.hostUrlLabel",
      defaultMessage: "URL"
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !(cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "relative"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.description",
    defaultMessage: "Specify multiple URLs to scale out your deployment and provide automatic failover. If multiple URLs exist, Fleet shows the first provided URL for enrollment purposes. Enrolled Elastic Agents will connect to the URLs in round robin order until they connect successfully. For more information, see the {link} .",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.settingsFleetServerHostSettings,
        target: "_blank",
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.settings.fleetServerHostsFlyout.userGuideLink",
        defaultMessage: "Fleet and Elastic Agent Guide"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_multi_row_input.MultiRowInput, (0, _extends2.default)({}, inputs.hostUrlsInput.props, {
    id: "fleet-server-inputs",
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsFlyout.fleetServerHostsInputPlaceholder', {
      defaultMessage: 'Specify host URL'
    }),
    isUrl: true,
    helpText: inputs.hostUrlsInput.props.disabled && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.serverlessHostUrlsHelpText",
      defaultMessage: "Custom host URLs are not allowed in serverless."
    })
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.proxyIdLabel",
      defaultMessage: "Proxy {badge}",
      values: {
        badge: /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
          size: "s",
          className: "eui-alignTop",
          label: _i18n.i18n.translate('xpack.fleet.settings.editDownloadSourcesFlyout.proxyIdBetaBadge', {
            defaultMessage: 'Beta'
          })
        })
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "fleetServerHostsFlyout.proxyIdInput"
  }, inputs.proxyIdInput.props, {
    onChange: options => {
      var _options$0$value, _options$;
      return inputs.proxyIdInput.setValue((_options$0$value = options === null || options === void 0 ? void 0 : (_options$ = options[0]) === null || _options$ === void 0 ? void 0 : _options$.value) !== null && _options$0$value !== void 0 ? _options$0$value : '');
    },
    selectedOptions: inputs.proxyIdInput.value !== '' ? proxiesOptions.filter(option => option.value === inputs.proxyIdInput.value) : [],
    options: proxiesOptions,
    singleSelection: {
      asPlainText: true
    },
    isDisabled: inputs.proxyIdInput.props.disabled,
    isClearable: true,
    placeholder: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsFlyout.proxyIdPlaceholder', {
      defaultMessage: 'Select proxy'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true
  }, inputs.isDefaultInput.formRowProps), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({
    "data-test-subj": "fleetServerHostsFlyout.isDefaultSwitch"
  }, inputs.isDefaultInput.props, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.fleetServerHostsFlyout.defaultOutputSwitchLabel",
      defaultMessage: "Make this Fleet server the default one."
    })
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => onClose(),
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isLoading: form.isLoading,
    isDisabled: form.isDisabled,
    onClick: form.submit,
    "data-test-subj": "saveApplySettingsBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.fleetServerHostsFlyout.saveButton",
    defaultMessage: "Save and apply settings"
  }))))));
};
exports.FleetServerHostsFlyout = FleetServerHostsFlyout;