"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetServerRequirementPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _hooks = require("../../../hooks");
var _fleet_server_callouts = require("../components/fleet_server_callouts");
var _components = require("../components");
var _components2 = require("../../../components");
var _components3 = require("./components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlexItemWithMinWidth = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-width: 0px;
  max-width: 100%;
`;
const ContentWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  height: 100%;
  margin: 0 auto;
`;
const FleetServerRequirementPage = ({
  showStandaloneTab = () => {},
  showEnrollmentRecommendation = true
}) => {
  var _startService$cloud;
  const startService = (0, _hooks.useStartServices)();
  const deploymentUrl = (_startService$cloud = startService.cloud) === null || _startService$cloud === void 0 ? void 0 : _startService$cloud.deploymentUrl;
  const {
    permissionsError,
    isPermissionsLoading
  } = (0, _hooks.useCheckPermissions)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ContentWrapper, {
    gutterSize: "none",
    justifyContent: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(FlexItemWithMinWidth, {
    grow: false
  }, deploymentUrl ? /*#__PURE__*/_react.default.createElement(_components3.CloudInstructions, {
    deploymentUrl: deploymentUrl
  }) : isPermissionsLoading ? /*#__PURE__*/_react.default.createElement(_components.Loading, null) : permissionsError ? /*#__PURE__*/_react.default.createElement(_fleet_server_callouts.FleetServerMissingPrivileges, null) : showEnrollmentRecommendation ? /*#__PURE__*/_react.default.createElement(_components3.EnrollmentRecommendation, {
    showStandaloneTab: showStandaloneTab
  }) : /*#__PURE__*/_react.default.createElement(_components2.AddFleetServerLanding, null))));
};
exports.FleetServerRequirementPage = FleetServerRequirementPage;