"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableRowActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../../../../../../common/services");
var _agent_status = require("../../../../../../../common/services/agent_status");
var _hooks = require("../../../../hooks");
var _use_authz = require("../../../../../../hooks/use_authz");
var _components = require("../../../../components");
var _services2 = require("../../../../services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TableRowActions = ({
  agent,
  agentPolicy,
  onReassignClick,
  onUnenrollClick,
  onGetUninstallCommandClick,
  onUpgradeClick,
  onAddRemoveTagsClick,
  onRequestDiagnosticsClick
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const authz = (0, _use_authz.useAuthz)();
  const isUnenrolling = agent.status === 'unenrolling';
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const {
    diagnosticFileUploadEnabled,
    agentTamperProtectionEnabled
  } = _services2.ExperimentalFeaturesService.get();
  const menuItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "inspect",
    href: getHref('agent_details', {
      agentId: agent.id
    }),
    key: "viewAgent"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.viewActionText",
    defaultMessage: "View agent"
  }))];
  if (authz.fleet.allAgents && (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.is_managed) === false) {
    menuItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "tag",
      onClick: event => {
        onAddRemoveTagsClick(event.target.closest('button'));
      },
      disabled: !agent.active,
      key: "addRemoveTags"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.addRemoveTagsActionText",
      defaultMessage: "Add / remove tags"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "pencil",
      onClick: () => {
        onReassignClick();
      },
      disabled: !agent.active,
      key: "reassignPolicy"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.reassignActionText",
      defaultMessage: "Assign to new policy"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "agentUnenrollBtn",
      disabled: !agent.active,
      icon: "trash",
      onClick: () => {
        onUnenrollClick();
      }
    }, isUnenrolling ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.forceUnenrollOneButton",
      defaultMessage: "Force unenroll"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.unenrollOneButton",
      defaultMessage: "Unenroll agent"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "agentUpgradeBtn",
      icon: "refresh",
      disabled: !(0, _services2.isAgentUpgradeable)(agent),
      onClick: () => {
        onUpgradeClick();
      },
      "data-test-subj": "upgradeBtn"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.upgradeOneButton",
      defaultMessage: "Upgrade agent"
    })));
    if (authz.fleet.allAgents && (0, _agent_status.isStuckInUpdating)(agent)) {
      menuItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "agentRestartUpgradeBtn",
        icon: "refresh",
        onClick: () => {
          onUpgradeClick();
        },
        "data-test-subj": "restartUpgradeBtn"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentList.restartUpgradeOneButton",
        defaultMessage: "Restart upgrade"
      })));
    }
    if (authz.fleet.allAgents && agentTamperProtectionEnabled && agent.policy_id) {
      menuItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        icon: "minusInCircle",
        onClick: () => {
          onGetUninstallCommandClick();
          setIsMenuOpen(false);
        },
        disabled: !agent.active,
        key: "getUninstallCommand",
        "data-test-subj": "uninstallAgentMenuItem"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentList.getUninstallCommand",
        defaultMessage: "Uninstall agent"
      })));
    }
  }
  if (authz.fleet.readAgents && diagnosticFileUploadEnabled) {
    menuItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "requestAgentDiagnosticsBtn",
      icon: "download",
      "data-test-subj": "requestAgentDiagnosticsBtn",
      disabled: !(0, _services.isAgentRequestDiagnosticsSupported)(agent),
      onClick: () => {
        onRequestDiagnosticsClick();
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.diagnosticsOneButton",
      defaultMessage: "Request diagnostics .zip"
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_components.ContextMenuActions, {
    isOpen: isMenuOpen,
    onChange: isOpen => setIsMenuOpen(isOpen),
    items: menuItems
  });
};
exports.TableRowActions = TableRowActions;