"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewLogsButton = void 0;
var _url = _interopRequireDefault(require("url"));
var _querystring = require("querystring");
var _react = _interopRequireWildcard(require("react"));
var _rison = require("@kbn/rison");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
  Button that takes to the Logs view Ui when that is available, otherwise fallback to the Discover UI
  The urls are built using same logStreamQuery (provided by a prop), startTime and endTime, ensuring that they'll both will target same log lines
*/
const ViewLogsButton = ({
  viewInLogs,
  logStreamQuery,
  startTime,
  endTime
}) => {
  const {
    http
  } = (0, _hooks.useStartServices)();

  // Generate URL to pass page state to Logs UI
  const viewInLogsUrl = (0, _react.useMemo)(() => http.basePath.prepend(_url.default.format({
    pathname: '/app/logs/stream',
    search: (0, _querystring.stringify)({
      logPosition: (0, _rison.encode)({
        start: startTime,
        end: endTime,
        streamLive: false
      }),
      logFilter: (0, _rison.encode)({
        expression: logStreamQuery,
        kind: 'kuery'
      })
    })
  })), [http.basePath, startTime, endTime, logStreamQuery]);
  const viewInDiscoverUrl = (0, _react.useMemo)(() => {
    const index = 'logs-*';
    const query = (0, _rison.encode)({
      query: logStreamQuery,
      language: 'kuery'
    });
    return http.basePath.prepend(`/app/discover#/?_g=(filters:!(),refreshInterval:(pause:!t,value:60000),time:(from:'${startTime}',to:'${endTime}'))&_a=(columns:!(event.dataset,message),index:'${index}',query:${query})`);
  }, [logStreamQuery, http.basePath, startTime, endTime]);
  return viewInLogs ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: viewInLogsUrl,
    iconType: "popout",
    "data-test-subj": "viewInLogsBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentLogs.openInLogsUiLinkText",
    defaultMessage: "Open in Logs"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: viewInDiscoverUrl,
    iconType: "popout",
    "data-test-subj": "viewInDiscoverBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentLogs.openInDiscoverUiLinkText",
    defaultMessage: "Open in Discover"
  }));
};
exports.ViewLogsButton = ViewLogsButton;