"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectLogLevel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../hooks");
var _constants = require("../../../../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LEVEL_VALUES = Object.values(_constants.AGENT_LOG_LEVELS);
const SelectLogLevel = exports.SelectLogLevel = /*#__PURE__*/(0, _react.memo)(({
  agent
}) => {
  var _agent$local_metadata, _agent$local_metadata2, _agent$local_metadata3, _agent$local_metadata4;
  const authz = (0, _hooks.useAuthz)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [agentLogLevel, setAgentLogLevel] = (0, _react.useState)((_agent$local_metadata = (_agent$local_metadata2 = agent.local_metadata) === null || _agent$local_metadata2 === void 0 ? void 0 : (_agent$local_metadata3 = _agent$local_metadata2.elastic) === null || _agent$local_metadata3 === void 0 ? void 0 : (_agent$local_metadata4 = _agent$local_metadata3.agent) === null || _agent$local_metadata4 === void 0 ? void 0 : _agent$local_metadata4.log_level) !== null && _agent$local_metadata !== void 0 ? _agent$local_metadata : _constants.DEFAULT_LOG_LEVEL);
  const [selectedLogLevel, setSelectedLogLevel] = (0, _react.useState)(agentLogLevel);
  const onClickApply = (0, _react.useCallback)(() => {
    setIsLoading(true);
    async function send() {
      try {
        const res = await (0, _hooks.sendPostAgentAction)(agent.id, {
          action: {
            type: 'SETTINGS',
            data: {
              log_level: selectedLogLevel
            }
          }
        });
        if (res.error) {
          throw res.error;
        }
        setAgentLogLevel(selectedLogLevel);
        notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.agentLogs.selectLogLevel.successText', {
          defaultMessage: `Changed agent logging level to '{logLevel}'.`,
          values: {
            logLevel: selectedLogLevel
          }
        }));
      } catch (error) {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.agentLogs.selectLogLevel.errorTitleText', {
            defaultMessage: 'Error updating agent logging level'
          })
        });
      }
      setIsLoading(false);
    }
    send();
  }, [notifications, selectedLogLevel, agent.id]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: "selectAgentLogLevel"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentLogs.selectLogLevelLabelText",
    defaultMessage: "Agent logging level"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    disabled: isLoading || !authz.fleet.allAgents,
    compressed: true,
    id: "selectAgentLogLevel",
    value: selectedLogLevel,
    onChange: event => {
      setSelectedLogLevel(event.target.value);
    },
    options: LEVEL_VALUES.map(level => ({
      text: level,
      value: level
    }))
  })), agentLogLevel !== selectedLogLevel && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "xs",
    isLoading: isLoading,
    disabled: agentLogLevel === selectedLogLevel,
    iconType: "refresh",
    onClick: onClickApply
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentLogs.updateButtonLoadingText",
    defaultMessage: "Applying changes..."
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentLogs.updateButtonText",
    defaultMessage: "Apply changes"
  }))));
});