"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradeStatusCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _hooks = require("../../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlyoutBody = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  .euiFlyoutBody__overflowContent {
    padding: 0;
  }
`;
const HasNewSecretsCallOut = ({
  newSecrets
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.upgradePackagePolicy.statusCallOut.hasNewSecretsTitle', {
      defaultMessage: 'New secrets added'
    }),
    color: "primary",
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradePackagePolicy.statusCallout.hasNewSecrets",
    defaultMessage: "Some of this integration's form fields have been converted to secrets in this version. Your existing values are autofilled in each secret input during this upgrade, but you won't be able to view them again after saving. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.policySecrets,
        target: "_blank"
      }, "Learn more.")
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradePackagePolicy.statusCallout.hasNewSecretsList",
    defaultMessage: "New secrets: {secrets}",
    values: {
      secrets: /*#__PURE__*/_react.default.createElement("ul", null, newSecrets.map(secret => /*#__PURE__*/_react.default.createElement("li", {
        key: secret.title
      }, secret.title)))
    }
  }));
};
const HasConflictsCallout = ({
  currentPackagePolicy,
  proposedUpgradePackagePolicy,
  onPreviousConfigurationClick
}) => {
  var _currentPackagePolicy, _proposedUpgradePacka;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.upgradePackagePolicy.statusCallOut.errorTitle', {
      defaultMessage: 'Review field conflicts'
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradePackagePolicy.statusCallout.errorContent",
    defaultMessage: "This integration has conflicting fields from version {currentVersion} to {upgradeVersion} Review the configuration and save to perform the upgrade. You may reference your {previousConfigurationLink} for comparison.",
    values: {
      currentVersion: currentPackagePolicy === null || currentPackagePolicy === void 0 ? void 0 : (_currentPackagePolicy = currentPackagePolicy.package) === null || _currentPackagePolicy === void 0 ? void 0 : _currentPackagePolicy.version,
      upgradeVersion: proposedUpgradePackagePolicy === null || proposedUpgradePackagePolicy === void 0 ? void 0 : (_proposedUpgradePacka = proposedUpgradePackagePolicy.package) === null || _proposedUpgradePacka === void 0 ? void 0 : _proposedUpgradePacka.version,
      previousConfigurationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: onPreviousConfigurationClick
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.upgradePackagePolicy.statusCallout.previousConfigurationLink",
        defaultMessage: "previous configuration"
      }))
    }
  }));
};
const ReadyToUpgradeCallOut = ({
  currentPackagePolicy,
  proposedUpgradePackagePolicy
}) => {
  var _currentPackagePolicy2, _proposedUpgradePacka2;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.fleet.upgradePackagePolicy.statusCallOut.successTitle', {
      defaultMessage: 'Ready to upgrade'
    }),
    color: "success",
    iconType: "checkInCircleFilled"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradePackagePolicy.statusCallout.successContent",
    defaultMessage: "This integration is ready to be upgraded from version {currentVersion} to {upgradeVersion}. Review the changes below and save to upgrade.",
    values: {
      currentVersion: currentPackagePolicy === null || currentPackagePolicy === void 0 ? void 0 : (_currentPackagePolicy2 = currentPackagePolicy.package) === null || _currentPackagePolicy2 === void 0 ? void 0 : _currentPackagePolicy2.version,
      upgradeVersion: proposedUpgradePackagePolicy === null || proposedUpgradePackagePolicy === void 0 ? void 0 : (_proposedUpgradePacka2 = proposedUpgradePackagePolicy.package) === null || _proposedUpgradePacka2 === void 0 ? void 0 : _proposedUpgradePacka2.version
    }
  }));
};
const UpgradeStatusCallout = ({
  dryRunData,
  newSecrets
}) => {
  var _dryRunData$0$agent_d;
  const [isPreviousVersionFlyoutOpen, setIsPreviousVersionFlyoutOpen] = (0, _react.useState)(false);
  if (!dryRunData) {
    return null;
  }
  const hasNewSecrets = newSecrets.length > 0;
  const [currentPackagePolicy, proposedUpgradePackagePolicy] = dryRunData[0].diff || [];
  const isReadyForUpgrade = currentPackagePolicy && !dryRunData[0].hasErrors;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isPreviousVersionFlyoutOpen && currentPackagePolicy && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => setIsPreviousVersionFlyoutOpen(false),
    size: "l",
    maxWidth: 640
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "FleetPackagePolicyPreviousVersionFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.upgradePackagePolicy.previousVersionFlyout.title",
    defaultMessage: "'{name}' integration policy",
    values: {
      name: currentPackagePolicy === null || currentPackagePolicy === void 0 ? void 0 : currentPackagePolicy.name
    }
  })))), /*#__PURE__*/_react.default.createElement(FlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    fontSize: "m",
    whiteSpace: "pre"
  }, JSON.stringify(((_dryRunData$0$agent_d = dryRunData[0].agent_diff) === null || _dryRunData$0$agent_d === void 0 ? void 0 : _dryRunData$0$agent_d[0]) || [], null, 2))))), isReadyForUpgrade ? /*#__PURE__*/_react.default.createElement(ReadyToUpgradeCallOut, {
    currentPackagePolicy: currentPackagePolicy,
    proposedUpgradePackagePolicy: proposedUpgradePackagePolicy
  }) : /*#__PURE__*/_react.default.createElement(HasConflictsCallout, {
    currentPackagePolicy: currentPackagePolicy,
    proposedUpgradePackagePolicy: proposedUpgradePackagePolicy,
    onPreviousConfigurationClick: () => setIsPreviousVersionFlyoutOpen(true)
  }), hasNewSecrets && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(HasNewSecretsCallOut, {
    newSecrets: newSecrets
  })));
};
exports.UpgradeStatusCallout = UpgradeStatusCallout;