"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDevToolsRequest = useDevToolsRequest;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _services = require("../../../../../services");
var _services2 = require("../../../services");
var _constants = require("../../../../../../../../common/constants");
var _components = require("../../components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDevToolsRequest({
  newAgentPolicy,
  packagePolicy,
  packageInfo,
  selectedPolicyTab,
  withSysMonitoring
}) {
  var _packageInfo$name;
  const {
    showDevtoolsRequest: isShowDevtoolRequestExperimentEnabled
  } = _services.ExperimentalFeaturesService.get();
  const showDevtoolsRequest = !_constants.HIDDEN_API_REFERENCE_PACKAGES.includes((_packageInfo$name = packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.name) !== null && _packageInfo$name !== void 0 ? _packageInfo$name : '') && isShowDevtoolRequestExperimentEnabled;
  const [devtoolRequest, devtoolRequestDescription] = (0, _react.useMemo)(() => {
    if (selectedPolicyTab === _components.SelectedPolicyTab.NEW) {
      var _packagePolicy$packag;
      const packagePolicyIsSystem = (packagePolicy === null || packagePolicy === void 0 ? void 0 : (_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.name) === _constants.FLEET_SYSTEM_PACKAGE;
      return [`${(0, _services2.generateCreateAgentPolicyDevToolsRequest)(newAgentPolicy, withSysMonitoring && !packagePolicyIsSystem)}\n\n${(0, _services2.generateCreatePackagePolicyDevToolsRequest)({
        ...{
          ...packagePolicy,
          policy_id: ''
        }
      })}`, _i18n.i18n.translate('xpack.fleet.createPackagePolicy.devtoolsRequestWithAgentPolicyDescription', {
        defaultMessage: 'These Kibana requests create a new agent policy and a new package policy.'
      })];
    }
    return [(0, _services2.generateCreatePackagePolicyDevToolsRequest)({
      ...packagePolicy
    }), _i18n.i18n.translate('xpack.fleet.createPackagePolicy.devtoolsRequestDescription', {
      defaultMessage: 'This Kibana request creates a new package policy.'
    })];
  }, [packagePolicy, newAgentPolicy, withSysMonitoring, selectedPolicyTab]);
  return {
    showDevtoolsRequest,
    devtoolRequest,
    devtoolRequestDescription
  };
}