"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentPolicyIntegrationForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _agent_policy_advanced_fields = require("./agent_policy_advanced_fields");
var _agent_policy_general_fields = require("./agent_policy_general_fields");
var _agent_policy_system_monitoring_field = require("./agent_policy_system_monitoring_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiAccordion = (0, _styledComponents.default)(_eui.EuiAccordion)`
  .ingest-active-button {
    color: ${props => props.theme.eui.euiColorPrimary};
  }
`;
const AgentPolicyIntegrationForm = ({
  agentPolicy,
  updateAgentPolicy,
  withSysMonitoring,
  updateSysMonitoring,
  validation
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.createAgentPolicyLabel",
      defaultMessage: "Create agent policy"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.createAgentPolicyDescription",
      defaultMessage: "Add this integration to a new set of hosts by creating a new agent policy. You can add agent in the next step."
    })
  }, /*#__PURE__*/_react.default.createElement(_agent_policy_general_fields.AgentPolicyGeneralFields, {
    agentPolicy: agentPolicy,
    updateAgentPolicy: updateAgentPolicy,
    validation: validation,
    nameLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.newAgentPolicyFieldLabel",
      defaultMessage: "New agent policy name"
    })
  }), /*#__PURE__*/_react.default.createElement(_agent_policy_system_monitoring_field.AgentPolicyFormSystemMonitoringCheckbox, {
    withSysMonitoring: withSysMonitoring,
    updateSysMonitoring: updateSysMonitoring
  })), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    id: "advancedOptions",
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentPolicyForm.advancedOptionsToggleLabel",
      defaultMessage: "Advanced options"
    }),
    buttonClassName: "ingest-active-button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_agent_policy_advanced_fields.AgentPolicyAdvancedOptionsContent, {
    agentPolicy: agentPolicy,
    updateAgentPolicy: updateAgentPolicy,
    validation: validation
  }))));
};
exports.AgentPolicyIntegrationForm = AgentPolicyIntegrationForm;