"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCheckPermissions = void 0;
var _reactQuery = require("@tanstack/react-query");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function checkPermissions() {
  let permissionsError;
  try {
    var _permissionsResponse$;
    const permissionsResponse = await (0, _hooks.sendGetPermissionsCheck)(true);
    if (!((_permissionsResponse$ = permissionsResponse.data) !== null && _permissionsResponse$ !== void 0 && _permissionsResponse$.success)) {
      var _permissionsResponse$2;
      permissionsError = ((_permissionsResponse$2 = permissionsResponse.data) === null || _permissionsResponse$2 === void 0 ? void 0 : _permissionsResponse$2.error) || 'REQUEST_ERROR';
    }
  } catch (err) {
    permissionsError = 'REQUEST_ERROR';
  }
  return permissionsError;
}
const useCheckPermissions = () => {
  const {
    data: permissionsError,
    status
  } = (0, _reactQuery.useQuery)(['fetch-check-permissions'], checkPermissions);
  return {
    isPermissionsLoading: status === 'loading',
    permissionsError
  };
};
exports.useCheckPermissions = useCheckPermissions;