"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRootPrivilegesRequired = isRootPrivilegesRequired;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Return true if a package need Elastic Agent to be run as root/administrator
 */
function isRootPrivilegesRequired(packageInfo) {
  var _packageInfo$agent, _packageInfo$agent$pr, _packageInfo$data_str;
  return ((_packageInfo$agent = packageInfo.agent) === null || _packageInfo$agent === void 0 ? void 0 : (_packageInfo$agent$pr = _packageInfo$agent.privileges) === null || _packageInfo$agent$pr === void 0 ? void 0 : _packageInfo$agent$pr.root) || ((_packageInfo$data_str = packageInfo.data_streams) === null || _packageInfo$data_str === void 0 ? void 0 : _packageInfo$data_str.some(d => {
    var _d$agent, _d$agent$privileges;
    return (_d$agent = d.agent) === null || _d$agent === void 0 ? void 0 : (_d$agent$privileges = _d$agent.privileges) === null || _d$agent$privileges === void 0 ? void 0 : _d$agent$privileges.root;
  }));
}