"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  SO_SEARCH_LIMIT: true,
  ES_SEARCH_LIMIT: true,
  FLEET_SERVER_INDICES_VERSION: true,
  FLEET_SERVER_ARTIFACTS_INDEX: true,
  FLEET_SERVER_SERVERS_INDEX: true,
  FLEET_SERVER_INDICES: true,
  DATA_TIERS: true,
  FLEET_ENROLLMENT_API_PREFIX: true,
  REQUEST_DIAGNOSTICS_TIMEOUT_MS: true,
  INTEGRATIONS_PLUGIN_ID: true,
  PLUGIN_ID: true,
  INGEST_SAVED_OBJECT_INDEX: true,
  FLEET_SETUP_LOCK_TYPE: true
};
exports.FLEET_SERVER_SERVERS_INDEX = exports.FLEET_SERVER_INDICES_VERSION = exports.FLEET_SERVER_INDICES = exports.FLEET_SERVER_ARTIFACTS_INDEX = exports.FLEET_ENROLLMENT_API_PREFIX = exports.ES_SEARCH_LIMIT = exports.DATA_TIERS = void 0;
Object.defineProperty(exports, "FLEET_SETUP_LOCK_TYPE", {
  enumerable: true,
  get: function () {
    return _saved_objects.FLEET_SETUP_LOCK_TYPE;
  }
});
Object.defineProperty(exports, "INGEST_SAVED_OBJECT_INDEX", {
  enumerable: true,
  get: function () {
    return _saved_objects.INGEST_SAVED_OBJECT_INDEX;
  }
});
Object.defineProperty(exports, "INTEGRATIONS_PLUGIN_ID", {
  enumerable: true,
  get: function () {
    return _plugin.INTEGRATIONS_PLUGIN_ID;
  }
});
Object.defineProperty(exports, "PLUGIN_ID", {
  enumerable: true,
  get: function () {
    return _plugin.PLUGIN_ID;
  }
});
exports.SO_SEARCH_LIMIT = exports.REQUEST_DIAGNOSTICS_TIMEOUT_MS = void 0;
var _plugin = require("./plugin");
var _saved_objects = require("./saved_objects");
var _routes = require("./routes");
Object.keys(_routes).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _routes[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _routes[key];
    }
  });
});
var _agent = require("./agent");
Object.keys(_agent).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _agent[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _agent[key];
    }
  });
});
var _agent_policy = require("./agent_policy");
Object.keys(_agent_policy).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _agent_policy[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _agent_policy[key];
    }
  });
});
var _package_policy = require("./package_policy");
Object.keys(_package_policy).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _package_policy[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _package_policy[key];
    }
  });
});
var _epm = require("./epm");
Object.keys(_epm).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _epm[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _epm[key];
    }
  });
});
var _output = require("./output");
Object.keys(_output).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _output[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _output[key];
    }
  });
});
var _enrollment_api_key = require("./enrollment_api_key");
Object.keys(_enrollment_api_key).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _enrollment_api_key[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _enrollment_api_key[key];
    }
  });
});
var _settings = require("./settings");
Object.keys(_settings).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _settings[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _settings[key];
    }
  });
});
var _preconfiguration = require("./preconfiguration");
Object.keys(_preconfiguration).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _preconfiguration[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _preconfiguration[key];
    }
  });
});
var _download_source = require("./download_source");
Object.keys(_download_source).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _download_source[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _download_source[key];
    }
  });
});
var _fleet_server_policy_config = require("./fleet_server_policy_config");
Object.keys(_fleet_server_policy_config).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _fleet_server_policy_config[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _fleet_server_policy_config[key];
    }
  });
});
var _authz = require("./authz");
Object.keys(_authz).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _authz[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _authz[key];
    }
  });
});
var _file_storage = require("./file_storage");
Object.keys(_file_storage).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _file_storage[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _file_storage[key];
    }
  });
});
var _message_signing_keys = require("./message_signing_keys");
Object.keys(_message_signing_keys).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _message_signing_keys[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _message_signing_keys[key];
    }
  });
});
var _locators = require("./locators");
Object.keys(_locators).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _locators[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _locators[key];
    }
  });
});
var _secrets = require("./secrets");
Object.keys(_secrets).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _secrets[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _secrets[key];
    }
  });
});
var _uninstall_token = require("./uninstall_token");
Object.keys(_uninstall_token).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _uninstall_token[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _uninstall_token[key];
    }
  });
});
var _mappings = require("./mappings");
Object.keys(_mappings).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _mappings[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _mappings[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: This is the default `index.max_result_window` ES setting, which dictates
// the maximum amount of results allowed to be returned from a search. It's possible
// for the actual setting to differ from the default. Can we retrieve the real
// setting in the future?
const SO_SEARCH_LIMIT = exports.SO_SEARCH_LIMIT = 10000;
const ES_SEARCH_LIMIT = exports.ES_SEARCH_LIMIT = 10000;
const FLEET_SERVER_INDICES_VERSION = exports.FLEET_SERVER_INDICES_VERSION = 1;
const FLEET_SERVER_ARTIFACTS_INDEX = exports.FLEET_SERVER_ARTIFACTS_INDEX = '.fleet-artifacts';
const FLEET_SERVER_SERVERS_INDEX = exports.FLEET_SERVER_SERVERS_INDEX = '.fleet-servers';
const FLEET_SERVER_INDICES = exports.FLEET_SERVER_INDICES = ['.fleet-actions', '.fleet-actions-results', '.fleet-agents', FLEET_SERVER_ARTIFACTS_INDEX, '.fleet-enrollment-api-keys', '.fleet-policies', '.fleet-policies-leader', FLEET_SERVER_SERVERS_INDEX];

// Nodes that can be queried by datastreams API
// Warm and cold nodes have been excluded because of performance issues
const DATA_TIERS = exports.DATA_TIERS = ['data_hot'];
const FLEET_ENROLLMENT_API_PREFIX = exports.FLEET_ENROLLMENT_API_PREFIX = 'fleet-enrollment-api-keys';
const REQUEST_DIAGNOSTICS_TIMEOUT_MS = exports.REQUEST_DIAGNOSTICS_TIMEOUT_MS = 3 * 60 * 60 * 1000; // 3 hours;