"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.referenceLineLayerFunction = void 0;
var _constants = require("../constants");
var _i18n = require("../i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const referenceLineLayerFunction = exports.referenceLineLayerFunction = {
  name: _constants.REFERENCE_LINE_LAYER,
  aliases: [],
  type: _constants.REFERENCE_LINE_LAYER,
  help: _i18n.strings.getRLHelp(),
  inputTypes: ['datatable'],
  args: {
    accessors: {
      types: ['string'],
      help: _i18n.strings.getRLAccessorsHelp(),
      multi: true
    },
    decorations: {
      types: [_constants.REFERENCE_LINE_DECORATION_CONFIG],
      help: _i18n.strings.getRLDecorationConfigHelp(),
      multi: true
    },
    columnToLabel: {
      types: ['string'],
      help: _i18n.strings.getColumnToLabelHelp()
    },
    table: {
      types: ['datatable'],
      help: _i18n.strings.getTableHelp()
    },
    layerId: {
      types: ['string'],
      help: _i18n.strings.getLayerIdHelp()
    }
  },
  async fn(input, args, context) {
    const {
      referenceLineLayerFn
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./reference_line_layer_fn')));
    return await referenceLineLayerFn(input, args, context);
  }
};