"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waffleConfig = exports.treemapMosaicConfig = exports.pieConfig = exports.config = void 0;
var _charts = require("@elastic/charts");
var _types = require("../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const config = exports.config = {
  addTooltip: true,
  legendDisplay: _types.LegendDisplay.HIDE,
  metricsToLabels: {
    percent_uptime: 'percent_uptime'
  },
  truncateLegend: true,
  respectSourceOrder: true,
  legendPosition: _charts.Position.Bottom,
  maxLegendLines: 1,
  palette: {
    type: 'palette',
    name: 'system_palette'
  },
  labels: {
    show: true,
    position: _types.LabelPositions.DEFAULT,
    percentDecimals: 2,
    values: true,
    truncate: 0,
    valuesFormat: _types.ValueFormats.PERCENT,
    last_level: false,
    colorOverrides: {}
  },
  dimensions: {
    metrics: [{
      type: 'vis_dimension',
      accessor: {
        id: 'percent_uptime',
        name: 'percent_uptime',
        meta: {
          type: 'number'
        }
      },
      format: {
        id: 'string',
        params: {}
      }
    }]
  }
};
const pieConfig = exports.pieConfig = {
  ...config,
  isDonut: false,
  emptySizeRatio: 0,
  distinctColors: false,
  nestedLegend: false,
  dimensions: {
    ...config.dimensions,
    buckets: [{
      type: 'vis_dimension',
      accessor: {
        id: 'project',
        name: 'project',
        meta: {
          type: 'string'
        }
      },
      format: {
        id: 'string',
        params: {}
      }
    }]
  },
  startFromSecondLargestSlice: true
};
const treemapMosaicConfig = exports.treemapMosaicConfig = {
  ...config,
  nestedLegend: false,
  dimensions: {
    ...config.dimensions,
    buckets: [{
      type: 'vis_dimension',
      accessor: {
        id: 'project',
        name: 'project',
        meta: {
          type: 'string'
        }
      },
      format: {
        id: 'string',
        params: {}
      }
    }]
  }
};
const waffleConfig = exports.waffleConfig = {
  ...config,
  dimensions: {
    ...config.dimensions,
    buckets: [{
      type: 'vis_dimension',
      accessor: {
        id: 'project',
        name: 'project',
        meta: {
          type: 'string'
        }
      },
      format: {
        id: 'string',
        params: {}
      }
    }]
  },
  showValuesInLegend: false
};