"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.heatmapRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _visualizationUtils = require("@kbn/visualization-utils");
var _public = require("@kbn/kibana-react-plugin/public");
var _analytics = require("@kbn/analytics");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("../../common");
var _services = require("../services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const heatmapRenderer = ({
  getStartDeps
}) => ({
  name: _common.EXPRESSION_HEATMAP_NAME,
  displayName: _i18n.i18n.translate('expressionHeatmap.visualizationName', {
    defaultMessage: 'Heatmap'
  }),
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    const {
      core,
      plugins
    } = getStartDeps();
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const onClickValue = data => {
      handlers.event({
        name: 'filter',
        data
      });
    };
    const onSelectRange = data => {
      handlers.event({
        name: 'brush',
        data
      });
    };
    const onClickMultiValue = data => {
      handlers.event({
        name: 'multiFilter',
        data
      });
    };
    const renderComplete = () => {
      const executionContext = handlers.getExecutionContext();
      const containerType = (0, _chartExpressionsCommon.extractContainerType)(executionContext);
      const visualizationType = (0, _chartExpressionsCommon.extractVisualizationType)(executionContext);
      if (containerType && visualizationType) {
        var _plugins$usageCollect;
        const events = [`render_${visualizationType}_${_common.EXPRESSION_HEATMAP_NAME}`, config.canNavigateToLens ? `render_${visualizationType}_${_common.EXPRESSION_HEATMAP_NAME}_convertable` : undefined].filter(event => Boolean(event));
        (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, events);
      }
      handlers.done();
    };
    const chartSizeEvent = {
      name: 'chartSize',
      data: {
        maxDimensions: {
          x: {
            value: 100,
            unit: 'percentage'
          },
          y: {
            value: 100,
            unit: 'percentage'
          }
        }
      }
    };
    handlers.event(chartSizeEvent);
    const timeZone = (0, _visualizationUtils.getTimeZone)((0, _services.getUISettings)());
    const {
      HeatmapComponent
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../components/heatmap_component')));
    const {
      isInteractive
    } = handlers;
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: core.theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "heatmap-container",
      "data-test-subj": "heatmapChart"
    }, /*#__PURE__*/_react.default.createElement(HeatmapComponent, (0, _extends2.default)({}, config, {
      onClickValue: onClickValue,
      onSelectRange: onSelectRange,
      timeZone: timeZone,
      datatableUtilities: (0, _services.getDatatableUtilities)(),
      formatFactory: (0, _services.getFormatService)().deserialize,
      chartsThemeService: plugins.charts.theme,
      paletteService: (0, _services.getPaletteService)(),
      renderComplete: renderComplete,
      uiState: handlers.uiState,
      interactive: isInteractive(),
      chartsActiveCursorService: plugins.charts.activeCursor,
      syncTooltips: config.syncTooltips,
      syncCursor: config.syncCursor,
      onClickMultiValue: onClickMultiValue
    }))))), domNode);
  }
});
exports.heatmapRenderer = heatmapRenderer;