"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupEditorFlyout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _group_editor_controls = require("./group_editor_controls");
var _group_preview = require("./group_preview");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const GroupEditorFlyout = ({
  group,
  updateGroup,
  onClose: parentOnClose,
  onSave,
  savedObjectsTagging,
  dataViews: globalDataViews,
  createDataView,
  LensEmbeddableComponent,
  queryInputServices,
  searchSessionId,
  refreshSearchSession,
  timePickerQuickRanges
}) => {
  const flyoutHeadingId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const flyoutBodyOverflowRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (!flyoutBodyOverflowRef.current) {
      flyoutBodyOverflowRef.current = document.querySelector('.euiFlyoutBody__overflow');
    }
  }, []);
  const [hasAttemptedSave, setHasAttemptedSave] = (0, _react.useState)(false);
  const resetContentScroll = (0, _react.useCallback)(() => flyoutBodyOverflowRef.current && flyoutBodyOverflowRef.current.scroll(0, 0), []);

  // save the spec for the life of the component since the user might change their mind after selecting another data view
  const [adHocDataView, setAdHocDataView] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    if (group.dataViewSpec) {
      createDataView(group.dataViewSpec).then(setAdHocDataView);
    }
  }, [createDataView, group.dataViewSpec]);
  const dataViews = (0, _react.useMemo)(() => {
    const items = [...globalDataViews];
    if (adHocDataView) {
      items.push(adHocDataView);
    }
    return items;
  }, [adHocDataView, globalDataViews]);
  const [selectedAnnotation, _setSelectedAnnotation] = (0, _react.useState)();
  const setSelectedAnnotation = (0, _react.useCallback)(newValue => {
    if (!newValue && selectedAnnotation || newValue && !selectedAnnotation) resetContentScroll();
    _setSelectedAnnotation(newValue);
  }, [resetContentScroll, selectedAnnotation]);
  const onClose = () => selectedAnnotation ? setSelectedAnnotation(undefined) : parentOnClose();
  const showPreview = !(0, _eui.useIsWithinBreakpoints)(['xs', 's', 'm']);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    paddingSize: "m",
    size: "l",
    hideCloseButton: true,
    outsideClickCloses: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
          height: 100%;
          overflow-y: auto;
        `,
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            ${showPreview ? 'width: 360px;' : ''}
            border-right: 1px solid ${_uiTheme.euiThemeVars.euiColorLightShade};
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "aria-labelledby": flyoutHeadingId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutHeadingId
  }, selectedAnnotation ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    iconType: "sortLeft",
    "aria-label": _i18n.i18n.translate('eventAnnotationListing.edit.back', {
      defaultMessage: 'Back'
    }),
    onClick: () => setSelectedAnnotation(undefined),
    "data-test-subj": "backToGroupSettingsTop"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "eventAnnotationListing.groupEditorFlyout.titleWithAnnotation",
    defaultMessage: "Date histogram axis annotation"
  }))) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "eventAnnotationListing.groupEditorFlyout.title",
    defaultMessage: "Edit annotation group"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_group_editor_controls.GroupEditorControls, {
    group: group,
    update: updateGroup,
    selectedAnnotation: selectedAnnotation,
    setSelectedAnnotation: setSelectedAnnotation,
    TagSelector: savedObjectsTagging.ui.components.SavedObjectSaveModalTagSelector,
    dataViews: dataViews,
    queryInputServices: queryInputServices,
    showValidation: hasAttemptedSave,
    isAdHocDataView: id => id === (adHocDataView === null || adHocDataView === void 0 ? void 0 : adHocDataView.id)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, selectedAnnotation ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "both",
    iconType: "sortLeft",
    "data-test-subj": "backToGroupSettings",
    onClick: () => setSelectedAnnotation(undefined)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "eventAnnotationListing.edit.back",
    defaultMessage: "Back"
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "cancelGroupEdit",
    onClick: onClose,
    size: "s",
    flush: "both"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "eventAnnotationListing.edit.cancel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    iconType: "save",
    "data-test-subj": "saveAnnotationGroup",
    fill: true,
    onClick: () => {
      setHasAttemptedSave(true);
      if ((0, _group_editor_controls.isGroupValid)(group, dataViews)) {
        onSave();
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "eventAnnotationListing.edit.save",
    defaultMessage: "Save annotation group"
  }))))))), showPreview && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
              background-color: ${_uiTheme.euiThemeVars.euiColorLightestShade};
            `
  }, /*#__PURE__*/_react.default.createElement(_group_preview.GroupPreview, {
    group: group,
    dataViews: dataViews,
    LensEmbeddableComponent: LensEmbeddableComponent,
    searchSessionId: searchSessionId,
    refreshSearchSession: refreshSearchSession,
    timePickerQuickRanges: timePickerQuickRanges
  }))));
};
exports.GroupEditorFlyout = GroupEditorFlyout;