"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFunctionsToIgnoreForStats = getFunctionsToIgnoreForStats;
exports.isAggFunctionUsedAlready = isAggFunctionUsedAlready;
var _helpers = require("../shared/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function extractFunctionArgs(args) {
  return args.flatMap(arg => (0, _helpers.isAssignment)(arg) ? arg.args[1] : arg).filter(_helpers.isFunctionItem);
}
function checkContent(fn) {
  const fnDef = (0, _helpers.getFunctionDefinition)(fn.name);
  return !!fnDef && fnDef.type === 'agg' || extractFunctionArgs(fn.args).some(checkContent);
}
function isAggFunctionUsedAlready(command, argIndex) {
  if (argIndex < 0) {
    return false;
  }
  const arg = command.args[argIndex];
  return (0, _helpers.isFunctionItem)(arg) ? checkContent(arg) : false;
}
function getFnContent(fn) {
  return [fn.name].concat(extractFunctionArgs(fn.args).flatMap(getFnContent));
}
function getFunctionsToIgnoreForStats(command, argIndex) {
  if (argIndex < 0) {
    return [];
  }
  const arg = command.args[argIndex];
  return (0, _helpers.isFunctionItem)(arg) ? getFnContent(arg) : [];
}