"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexPatternFromESQLQuery = getIndexPatternFromESQLQuery;
exports.getIndexPatternFromSQLQuery = getIndexPatternFromSQLQuery;
exports.getLimitFromESQLQuery = getLimitFromESQLQuery;
exports.removeDropCommandsFromESQLQuery = removeDropCommandsFromESQLQuery;
var _esqlAst = require("@kbn/esql-ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DEFAULT_ESQL_LIMIT = 500;

// retrieves the index pattern from the aggregate query for SQL
function getIndexPatternFromSQLQuery(sqlQuery) {
  var _sql, _splitFroms$length, _sql2;
  let sql = sqlQuery === null || sqlQuery === void 0 ? void 0 : sqlQuery.replaceAll('"', '').replaceAll("'", '');
  const splitFroms = (_sql = sql) === null || _sql === void 0 ? void 0 : _sql.split(new RegExp(/FROM\s/, 'ig'));
  const fromsLength = (_splitFroms$length = splitFroms === null || splitFroms === void 0 ? void 0 : splitFroms.length) !== null && _splitFroms$length !== void 0 ? _splitFroms$length : 0;
  if (splitFroms && (splitFroms === null || splitFroms === void 0 ? void 0 : splitFroms.length) > 2) {
    sql = `${splitFroms[fromsLength - 2]} FROM ${splitFroms[fromsLength - 1]}`;
  }
  // case insensitive match for the index pattern
  const regex = new RegExp(/FROM\s+([(\w*:)?\w*-.!@$^()~;]+)/, 'i');
  const matches = (_sql2 = sql) === null || _sql2 === void 0 ? void 0 : _sql2.match(regex);
  if (matches) {
    return matches[1];
  }
  return '';
}

// retrieves the index pattern from the aggregate query for ES|QL using ast parsing
function getIndexPatternFromESQLQuery(esql) {
  var _fromCommand$args;
  const {
    ast
  } = (0, _esqlAst.getAstAndSyntaxErrors)(esql);
  const fromCommand = ast.find(({
    name
  }) => name === 'from');
  const args = (_fromCommand$args = fromCommand === null || fromCommand === void 0 ? void 0 : fromCommand.args) !== null && _fromCommand$args !== void 0 ? _fromCommand$args : [];
  const indices = args.filter(arg => arg.sourceType === 'index');
  return indices === null || indices === void 0 ? void 0 : indices.map(index => index.text).join(',');
}
function getLimitFromESQLQuery(esql) {
  const limitCommands = esql.match(new RegExp(/LIMIT\s[0-9]+/, 'ig'));
  if (!limitCommands) {
    return DEFAULT_ESQL_LIMIT;
  }
  const lastIndex = limitCommands.length - 1;
  const split = limitCommands[lastIndex].split(' ');
  return parseInt(split[1], 10);
}
function removeDropCommandsFromESQLQuery(esql) {
  const pipes = (esql || '').split('|');
  return pipes.filter(statement => !/DROP\s/i.test(statement)).join('|');
}