"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createError = createError;
var _ast_position_utils = require("./ast_position_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function createError(exception) {
  const token = exception.offendingToken;
  return {
    type: 'error',
    text: `SyntaxError: ${exception.message}`,
    location: (0, _ast_position_utils.getPosition)(token)
  };
}