"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESQLErrorListener = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _antlr = require("antlr4");
var _ast_position_utils = require("./ast_position_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ESQLErrorListener extends _antlr.ErrorListener {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "errors", []);
  }
  syntaxError(recognizer, offendingSymbol, line, column, message, error) {
    const textMessage = `SyntaxError: ${message}`;
    const tokenPosition = (0, _ast_position_utils.getPosition)(offendingSymbol);
    const startColumn = offendingSymbol && tokenPosition ? tokenPosition.min + 1 : column + 1;
    const endColumn = offendingSymbol && tokenPosition ? tokenPosition.max + 1 : column + 2;
    this.errors.push({
      startLineNumber: line,
      endLineNumber: line,
      startColumn,
      endColumn,
      message: textMessage,
      severity: 'error'
    });
  }
  getErrors() {
    return this.errors;
  }
}
exports.ESQLErrorListener = ESQLErrorListener;