"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkplaceSearchGatePage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _doc_links = require("../../../shared/doc_links");
var _layout = require("../../../shared/layout");
var _telemetry = require("../../../shared/telemetry");
var _gated_form = require("./gated_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkplaceSearchGatePage = ({
  isLoading
}) => {
  return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchPageTemplateWrapper, {
    restrictWidth: true,
    pageHeader: {
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.workplaceSearch.gateForm.description",
        defaultMessage: "The standalone Workplace Search product remains available in maintenance mode, and is not recommended for new search experiences. Instead, we recommend using our set of Elasticsearch-native tools, which our team is actively developing and improving, for your workplace search use case. These tools offer the flexibility and composability of working directly with Elasticsearch indices. Learn more about the context for this refocus in this {blogUrl}. To help choose which of these tools best suit your use case, we\u2019ve created this recommendation wizard. Let us know what features you need, and we'll guide you to the best solutions. If you still want to go ahead and use the standalone Workplace Search product at this point, you can do so after submitting the form.",
        values: {
          blogUrl: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "workplaceSearch-gateForm-blog-link",
            href: _doc_links.docLinks.workplaceSearchGatedFormBlog,
            target: "_blank",
            "data-telemetry-id": "workplaceSearch-gateForm-blog-viewLink"
          }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.viewBlog', {
            defaultMessage: 'blog'
          }))
        }
      }),
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.title', {
        defaultMessage: 'Before you begin...'
      })
    },
    solutionNav: {
      items: (0, _layout.useEnterpriseSearchNav)(),
      name: _constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.NAME
    },
    isLoading: isLoading,
    hideEmbeddedConsole: true
  }, /*#__PURE__*/_react.default.createElement(_telemetry.SendWorkplaceSearchTelemetry, {
    action: "viewed",
    metric: "Workplace Search Gate form"
  }), /*#__PURE__*/_react.default.createElement(_gated_form.WorkplaceSearchGate, null));
};
exports.WorkplaceSearchGatePage = WorkplaceSearchGatePage;