"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkplaceSearchGate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../shared/doc_links");
var _gated_form_logic = require("./gated_form_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFeature = id => {
  switch (id) {
    case featuresList.searchApplication.id:
      return featuresList.searchApplication;
    case featuresList.contentSources.id:
      return featuresList.contentSources;
    case featuresList.contentExtraction.id:
      return featuresList.contentExtraction;
    case featuresList.documentLevelPermissions.id:
      return featuresList.documentLevelPermissions;
    case featuresList.synonyms.id:
      return featuresList.synonyms;
    case featuresList.analytics.id:
      return featuresList.analytics;
  }
};
const featuresList = {
  analytics: {
    actionLabel: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.analytics.action.Label', {
      defaultMessage: 'Start with Behavioral Analytics'
    }),
    actionLink: './analytics ',
    addOnLearnMoreLabel: undefined,
    addOnLearnMoreUrl: undefined,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.analytics.featureDescription', {
      defaultMessage: "Did you know you can easily analyze your users' searching and clicking behavior with Behavioral Analytics? Instrument your website or application for tracking relevant user actions."
    }),
    id: 'Analytics',
    learnMore: 'https://www.elastic.co/guide/en/enterprise-search/current/analytics-overview.html',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.analytics.featureName', {
      defaultMessage: 'Use Behavioral Analytics'
    })
  },
  contentExtraction: {
    actionLabel: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.connectorExtraction.featureButtonLabel', {
      defaultMessage: 'Use a connector '
    }),
    actionLink: './content/search_indices/new_index/select_connector',
    addOnLearnMoreLabel: undefined,
    addOnLearnMoreUrl: undefined,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.connectorExtraction.featureDescription', {
      defaultMessage: 'Did you know you have access to powerful content extraction via Elastic connectors! Use our powerful and highly adaptable extraction capabilities to extract contents from your files. '
    }),
    id: 'Content Extraction',
    learnMore: 'https://www.elastic.co/guide/en/enterprise-search/current/connectors.html ',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.connectorExtraction.featureName', {
      defaultMessage: 'Use Elastic connectors'
    })
  },
  contentSources: {
    actionLabel: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.connectorSources.featureButtonLabel', {
      defaultMessage: 'Use a connector '
    }),
    actionLink: './content/search_indices/new_index/select_connector',
    addOnLearnMoreLabel: undefined,
    addOnLearnMoreUrl: undefined,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.connectorSources.featureDescription', {
      defaultMessage: 'Did you know Elastic connectors are now available? You can keep content on your data sources in sync with your search-optimized indices! '
    }),
    id: 'Content sources',
    learnMore: 'https://www.elastic.co/guide/en/enterprise-search/current/connectors.html ',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.connectorSources.featureName', {
      defaultMessage: 'Use Elastic connectors'
    })
  },
  documentLevelPermissions: {
    actionLabel: undefined,
    actionLink: undefined,
    addOnLearnMoreLabel: undefined,
    addOnLearnMoreUrl: undefined,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.docLevelPermissions.featureDescription', {
      defaultMessage: 'Did you know you can restrict access to documents in your Elasticsearch indices according to user and group permissions? Return only authorized search results for users with Elastic’s document level security. '
    }),
    id: 'Document Level Permissions',
    learnMore: 'https://www.elastic.co/guide/en/enterprise-search/current/dls.html',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.docLevelPermissions.featureName', {
      defaultMessage: 'Use Elastic connectors'
    })
  },
  searchApplication: {
    actionLabel: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.searchApplication.action.Label', {
      defaultMessage: 'Create a Search Application'
    }),
    actionLink: './applications/search_applications',
    addOnLearnMoreLabel: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.searchApplication.addOn.learnMoreLabel', {
      defaultMessage: 'Search UI'
    }),
    addOnLearnMoreUrl: 'https://www.elastic.co/guide/en/enterprise-search/current/search-ui.html  ',
    description: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.searchApplication.featureDescription', {
      defaultMessage: 'Did you know you can restrict access to documents in your Elasticsearch indices according to user and group permissions? Return only authorized search results for users with Elastic’s document level security. '
    }),
    id: 'Search Application',
    learnMore: 'https://www.elastic.co/guide/en/enterprise-search/current/search-applications.html',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.searchApplication.featureName', {
      defaultMessage: 'Create Search Application'
    })
  },
  synonyms: {
    actionLabel: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.synonyms.action.Label', {
      defaultMessage: 'Search with synonyms'
    }),
    actionLink: 'https://www.elastic.co/guide/en/elasticsearch/reference/current/search-with-synonyms.html ',
    addOnLearnMoreLabel: undefined,
    addOnLearnMoreUrl: undefined,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.synonyms.featureDescription', {
      defaultMessage: 'Did you know you can improve your search experience by searching with synonyms? Use our Synonyms API to easily create and manage synonym sets.'
    }),
    id: 'Synonyms',
    learnMore: 'https://www.elastic.co/guide/en/elasticsearch/reference/8.10/synonyms-apis.html',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.synonyms.featureName', {
      defaultMessage: 'Search with Synonyms API'
    })
  }
};
const participateInUXLabsChoice = {
  no: {
    choice: 'no',
    value: false
  },
  yes: {
    choice: 'yes',
    value: true
  }
};
const EducationPanel = ({
  featureContent
}) => {
  const feature = getFeature(featureContent);
  const {
    setFeaturesOther
  } = (0, _kea.useActions)(_gated_form_logic.WorkplaceSearchGateLogic);
  if (feature) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoElastic"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.educationalPanel.title', {
      defaultMessage: 'Elasticsearch native equivalent'
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.educationalPanel.subTitle', {
      defaultMessage: 'Based on your selection we recommend you'
    }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: feature.title,
      color: "success",
      iconType: "checkInCircleFilled"
    }, /*#__PURE__*/_react.default.createElement("p", null, feature.description), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      wrap: true,
      alignItems: "baseline"
    }, feature.actionLink !== undefined && feature.actionLabel !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: feature.actionLink,
      iconType: "sortRight",
      iconSide: "right"
    }, feature.actionLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: feature.learnMore,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.educationalPanel.learnMore', {
      defaultMessage: 'Learn More'
    }))), feature.addOnLearnMoreLabel !== undefined && feature.addOnLearnMoreUrl !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      type: "button",
      href: feature.addOnLearnMoreUrl,
      target: "_blank",
      external: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), feature.addOnLearnMoreLabel)))));
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.featureOther.Label', {
        defaultMessage: "Can you explain what other feature(s) you're looking for?"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      onChange: e => {
        setFeaturesOther(e.target.value);
      }
    })));
  }
};
const WorkplaceSearchGate = () => {
  var _feature;
  const options = [{
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.contentSource.title', {
      defaultMessage: 'Content sources'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.contentSource.description', {
      defaultMessage: 'Extract the content of synced source files to make them searchable'
    })))),
    inputDisplay: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.contentSource.inputDisplay', {
      defaultMessage: 'Content Sources'
    }),
    value: featuresList.contentSources.id
  }, {
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.contentExtraction.title', {
      defaultMessage: 'Content extraction'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.contentExtraction.description', {
      defaultMessage: 'Extract the content of synced source files to make them searchable'
    })))),
    inputDisplay: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.contentExtraction.inputDisplay', {
      defaultMessage: 'Content extraction'
    }),
    value: featuresList.contentExtraction.id
  }, {
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.docLevelPermissions.title', {
      defaultMessage: 'Document-level permissions'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.docLevelPermissions.description', {
      defaultMessage: 'Control access to specific documents'
    })))),
    inputDisplay: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.docLevelPermissions.inputDisplay', {
      defaultMessage: 'Document-level permissions'
    }),
    value: featuresList.documentLevelPermissions.id
  }, {
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.searchApplication.title', {
      defaultMessage: 'An out-of-the-box search experience'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.searchApplication.description', {
      defaultMessage: 'Easily build search-powered applications'
    })))),
    inputDisplay: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.searchApplication.inputDisplay', {
      defaultMessage: 'An out-of-the-box search experience'
    }),
    value: featuresList.searchApplication.id
  }, {
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.synonymns.title', {
      defaultMessage: 'Synonyms'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.synonymns.description', {
      defaultMessage: 'Link different words or phrases with similar meanings'
    })))),
    inputDisplay: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.synonymns.inputDisplay', {
      defaultMessage: 'Synonyms'
    }),
    value: featuresList.synonyms.id
  }, {
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.analytics.title', {
      defaultMessage: 'Analytics'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.analytics.description', {
      defaultMessage: "Record and review users' interactions with search results"
    })))),
    inputDisplay: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.analytics.inputDisplay', {
      defaultMessage: 'Analytics'
    }),
    value: featuresList.analytics.id
  }, {
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.other.title', {
      defaultMessage: 'Other'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.other.description', {
      defaultMessage: 'Another feature not listed here'
    })))),
    inputDisplay: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.superSelect.other.inputDisplay', {
      defaultMessage: 'Other'
    }),
    value: 'other'
  }];
  const {
    formSubmitRequest,
    setAdditionalFeedback,
    setParticipateInUXLabs,
    setFeature
  } = (0, _kea.useActions)(_gated_form_logic.WorkplaceSearchGateLogic);
  const {
    feature,
    participateInUXLabs
  } = (0, _kea.useValues)(_gated_form_logic.WorkplaceSearchGateLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.features.Label', {
    defaultMessage: 'What Workplace Search feature are you looking to use?'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: options,
    valueOfSelected: feature,
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.features.selectOption', {
      defaultMessage: 'Select an option'
    }),
    onChange: value => setFeature(value),
    itemLayoutAlign: "top",
    hasDividers: true,
    fullWidth: true
  }), feature && /*#__PURE__*/_react.default.createElement(EducationPanel, {
    featureContent: feature
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.additionalFeedback.Label', {
      defaultMessage: 'Would you like to share any additional feedback?'
    }),
    labelAppend: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.additionalFeedback.optionalLabel', {
      defaultMessage: 'Optional'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    onChange: e => {
      setAdditionalFeedback(e.target.value);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.gateForm.additionalFeedback.description",
    defaultMessage: " By submitting feedback you acknowledge that you've read and agree to our {termsOfService}, and that Elastic may {contact} about our related products and services, using the details you provide above. See {privacyStatementLink} for more details or to opt-out at any time.",
    values: {
      contact: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.workplaceSearchGatedFormDataUse
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.workplaceSearch.gateForm.additionalFeedback.contact",
        defaultMessage: "contact you"
      })),
      privacyStatementLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.workplaceSearchGatedFormPrivacyStatement
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.workplaceSearch.gateForm.additionalFeedback.readDataPrivacyStatementLink",
        defaultMessage: "Elastic\u2019s Privacy Statement"
      })),
      termsOfService: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _doc_links.docLinks.workplaceSearchGatedFormTermsOfService
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.workplaceSearch.gateForm.additionalFeedback.readTermsOfService",
        defaultMessage: "Terms of Service"
      }))
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    labelAppend: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.participateUxLab.optionalLabel', {
      defaultMessage: 'Optional'
    }),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.participateUxLab.Label', {
      defaultMessage: 'Join our user research studies to improve Elasticsearch?'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    hasNoInitialSelection: true,
    options: [{
      text: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.participateUxLab.Label.Yes', {
        defaultMessage: 'Yes'
      }),
      value: participateInUXLabsChoice.yes.choice
    }, {
      text: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.participateUxLab.Label.No', {
        defaultMessage: 'No'
      }),
      value: participateInUXLabsChoice.no.choice
    }],
    onChange: e => setParticipateInUXLabs(e.target.value === participateInUXLabsChoice.yes.choice ? participateInUXLabsChoice.yes.value : participateInUXLabsChoice.no.value),
    value: participateInUXLabs != null ? participateInUXLabs ? participateInUXLabsChoice.yes.choice : participateInUXLabsChoice.no.choice : undefined
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: (_feature = !feature) !== null && _feature !== void 0 ? _feature : false,
    type: "submit",
    fill: true,
    onClick: () => formSubmitRequest()
  }, _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.gateForm.submit', {
    defaultMessage: 'Submit'
  }))))));
};
exports.WorkplaceSearchGate = WorkplaceSearchGate;