"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccountSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _kibana_logic = require("../../../shared/kibana/kibana_logic");
var _layout = require("../../components/layout");
var _constants = require("../../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AccountSettings = () => {
  const {
    security
  } = (0, _kea.useValues)(_kibana_logic.KibanaLogic);
  const [currentUser, setCurrentUser] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    if (security) {
      security.authc.getCurrentUser().then(setCurrentUser).catch(() => {
        setCurrentUser(null);
      });
    }
  }, [security === null || security === void 0 ? void 0 : security.authc]);
  const PersonalInfo = (0, _react.useMemo)(() => security === null || security === void 0 ? void 0 : security.uiApi.components.getPersonalInfo, [security === null || security === void 0 ? void 0 : security.uiApi]);
  const ChangePassword = (0, _react.useMemo)(() => security === null || security === void 0 ? void 0 : security.uiApi.components.getChangePassword, [security === null || security === void 0 ? void 0 : security.uiApi]);
  if (!currentUser) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_layout.PersonalDashboardLayout, {
    pageChrome: [_constants.ACCOUNT_SETTINGS_TITLE]
  }, PersonalInfo ? /*#__PURE__*/_react.default.createElement(PersonalInfo, {
    user: currentUser
  }) : null, ChangePassword ? /*#__PURE__*/_react.default.createElement(ChangePassword, {
    user: currentUser
  }) : null);
};
exports.AccountSettings = AccountSettings;