"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CredentialItem = exports.COPY_TOOLTIP = exports.COPIED_TOOLTIP = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COPY_TOOLTIP = exports.COPY_TOOLTIP = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.credentialItem.copy.tooltip', {
  defaultMessage: 'Copy to clipboard'
});
const COPIED_TOOLTIP = exports.COPIED_TOOLTIP = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.credentialItem.copied.tooltip', {
  defaultMessage: 'Copied!'
});
const inputSelectAll = e => e.currentTarget.select();
const CredentialItem = ({
  label,
  value,
  testSubj,
  hideCopy
}) => {
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  const SHOW_CREDENTIAL_TOOLTIP = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.credentialItem.show.tooltip', {
    defaultMessage: 'Show {credential}.',
    values: {
      credential: label
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    "data-test-subj": testSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, label))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, !hideCopy && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    beforeMessage: COPY_TOOLTIP,
    afterMessage: COPIED_TOOLTIP,
    textToCopy: value
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": COPY_TOOLTIP,
    onClick: copy,
    iconType: "copy",
    color: "primary"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: SHOW_CREDENTIAL_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": SHOW_CREDENTIAL_TOOLTIP,
    "data-test-subj": `Show${(0, _lodash.upperFirst)(testSubj)}`,
    onClick: () => setIsVisible(!isVisible),
    iconType: isVisible ? 'eyeClosed' : 'eye',
    color: "primary"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, !isVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
    placeholder: label,
    value: value,
    readOnly: true,
    compressed: true,
    disabled: true
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    readOnly: true,
    placeholder: "Compressed",
    "data-test-subj": `${testSubj}Input`,
    value: value,
    compressed: true,
    onClick: inputSelectAll
  })))));
};
exports.CredentialItem = CredentialItem;