"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoleMappingsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../constants");
require("./role_mappings_table.scss");
var _constants2 = require("./constants");
var _users_and_roles_row_actions = require("./users_and_roles_row_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RoleMappingsTable = ({
  accessItemKey,
  accessHeader,
  roleMappings,
  initializeRoleMapping,
  handleDeleteMapping
}) => {
  const getFirstAttributeName = rules => Object.entries(rules)[0][0];
  const getFirstAttributeValue = rules => Object.entries(rules)[0][1];

  // This is needed because App Search has `engines` and Workplace Search has `groups`.
  const standardizedRoleMappings = roleMappings.map(rm => {
    const _rm = {
      ...rm
    };
    _rm.accessItems = rm[accessItemKey];
    return _rm;
  });
  const [items, setItems] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    setItems(standardizedRoleMappings);
  }, [roleMappings]);
  const attributeNameCol = {
    field: 'attribute',
    name: /*#__PURE__*/_react.default.createElement("span", null, _constants2.EXTERNAL_ATTRIBUTE_LABEL, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "iInCircle",
      color: "subdued",
      content: _constants2.EXTERNAL_ATTRIBUTE_TOOLTIP,
      iconProps: {
        className: 'eui-alignTop'
      }
    })),
    render: (_, {
      rules
    }) => getFirstAttributeName(rules)
  };
  const attributeValueCol = {
    field: 'attributeValue',
    name: _constants2.ATTRIBUTE_VALUE_LABEL,
    render: (_, {
      rules
    }) => getFirstAttributeValue(rules)
  };
  const roleCol = {
    field: 'roleType',
    name: _constants2.ROLE_LABEL,
    render: (_, {
      roleType
    }) => roleType
  };
  const accessItemsCol = {
    field: 'accessItems',
    name: accessHeader,
    render: (_, {
      accessAllEngines,
      accessItems
    }) => {
      // Design calls for showing the first 2 items followed by a +x after those 2.
      // ['foo', 'bar', 'baz'] would display as: "foo, bar + 1"
      const numItems = accessItems.length;
      if (accessAllEngines || numItems === 0) return /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "AllItems"
      }, _constants2.ALL_LABEL);
      const additionalItems = numItems > 2 ? ` + ${numItems - 2}` : '';
      const names = accessItems.map(item => item.name);
      return /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "AccessItems"
      }, names.slice(0, 2).join(', ') + additionalItems);
    }
  };
  const actionsCol = {
    field: 'id',
    name: _constants.ACTIONS_HEADER,
    align: 'right',
    render: (_, {
      id,
      toolTip
    }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, id && /*#__PURE__*/_react.default.createElement(_users_and_roles_row_actions.UsersAndRolesRowActions, {
      onManageClick: () => initializeRoleMapping(id),
      onDeleteClick: () => handleDeleteMapping(id)
    }), toolTip && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "left",
      content: toolTip.content
    }))
  };
  const columns = [attributeNameCol, attributeValueCol, roleCol, accessItemsCol, actionsCol];
  const pagination = {
    showPerPageOptions: false,
    pageSize: 10
  };
  const onQueryChange = ({
    queryText
  }) => {
    const filteredItems = standardizedRoleMappings.filter(rm => {
      // JSON.stringify allows us to search all the object fields
      // without converting all the nested arrays and objects to strings manually
      // Some false-positives are possible, because the search is also performed on
      // object keys, but the simplicity of JSON.stringify seems to worth the tradeoff.
      const normalizedTableItemString = JSON.stringify(rm).toLowerCase();
      const normalizedQuery = queryText.toLowerCase();
      return normalizedTableItemString.indexOf(normalizedQuery) !== -1;
    });
    setItems(filteredItems);
  };
  const search = {
    onChange: onQueryChange,
    box: {
      incremental: true,
      fullWidth: false,
      placeholder: _constants2.FILTER_ROLE_MAPPINGS_PLACEHOLDER,
      'data-test-subj': 'RoleMappingsTableSearchInput'
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "RoleMappingsTable",
    columns: columns,
    items: items,
    search: search,
    pagination: pagination,
    message: _constants2.ROLE_MAPPINGS_NO_RESULTS_MESSAGE,
    responsive: false
  });
};
exports.RoleMappingsTable = RoleMappingsTable;