"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultSettingsFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../shared/doc_links");
var _settings_logic = require("./settings_logic");
var _settings_panel = require("./settings_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Callout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.defaultSettingsFlyout.callout.title', {
    defaultMessage: 'Individual settings management'
  })
}, _i18n.i18n.translate('xpack.enterpriseSearch.defaultSettingsFlyout.callout.body', {
  defaultMessage: 'You can also enable or disable this feature for a specific index on the index’s configuration page.'
}));
const DefaultSettingsFlyout = ({
  closeFlyout
}) => {
  const {
    makeRequest,
    setPipeline
  } = (0, _kea.useActions)(_settings_logic.SettingsLogic);
  const {
    defaultPipeline,
    hasNoChanges,
    isLoading,
    pipelineState
  } = (0, _kea.useValues)(_settings_logic.SettingsLogic);
  const {
    extract_binary_content: extractBinaryContent,
    reduce_whitespace: reduceWhitespace,
    run_ml_inference: runMLInference
  } = pipelineState;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    size: "s",
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.defaultSettingsFlyout.h2.defaultSettingsLabel', {
    defaultMessage: 'Default Settings'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: Callout
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.defaultSettingsFlyout.body.description.label",
    defaultMessage: "These settings apply to all new Elasticsearch indices created by Search ingestion mechanisms. For API ingest-based indices, remember to include the pipeline when you ingest documents. These features are powered by {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "entSearchContent-defaultSettingsFlyout-ingestPipelinesLink",
        "data-telemetry-id": "entSearchContent-defaultSettingsFlyout-ingestPipelinesLink",
        href: _doc_links.docLinks.ingestPipelines,
        target: "_blank"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.defaultSettingsFlyout.body.description.ingestPipelinesLink.link', {
        defaultMessage: 'ingest pipelines'
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_settings_panel.SettingsPanel, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.contentExtraction.description', {
      defaultMessage: 'Extract searchable content from binary files, like PDFs and Word documents.'
    }),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.contactExtraction.label', {
      defaultMessage: 'Content extraction'
    }),
    onChange: () => setPipeline({
      ...pipelineState,
      extract_binary_content: !pipelineState.extract_binary_content
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.contentExtraction.title', {
      defaultMessage: 'Deployment wide content extraction'
    }),
    value: extractBinaryContent
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_settings_panel.SettingsPanel, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.whiteSpaceReduction.description', {
      defaultMessage: 'Whitespace reduction will strip your full-text content of whitespace by default.'
    }),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.whitespaceReduction.label', {
      defaultMessage: 'Whitespace reduction'
    }),
    onChange: () => setPipeline({
      ...pipelineState,
      reduce_whitespace: !pipelineState.reduce_whitespace
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.whitespaceReduction.deploymentHeaderTitle', {
      defaultMessage: 'Deployment wide whitespace reduction'
    }),
    value: reduceWhitespace
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_settings_panel.SettingsPanel, {
    description: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.mlInference.description', {
      defaultMessage: 'ML Inference Pipelines will run as part of your pipelines. You will have to configure processors for each index individually on its pipelines page.'
    }),
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.mlInference.label', {
      defaultMessage: 'ML Inference'
    }),
    link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "entSearchContent-defaultSettingsFlyout-mlInferenceLink",
      "data-telemetry-id": "entSearchContent-defaultSettingsFlyout-mlInferenceLink",
      href: _doc_links.docLinks.mlDocumentEnrichment,
      target: "_blank"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.mlInference.link', {
      defaultMessage: 'Learn more about document enrichment with ML'
    })),
    onChange: () => setPipeline({
      ...pipelineState,
      run_ml_inference: !pipelineState.run_ml_inference
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.mlInference.deploymentHeaderTitle', {
      defaultMessage: 'Deployment wide ML Inference Pipelines extraction'
    }),
    value: runMLInference
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => closeFlyout(),
    "data-test-subj": 'entSearchContentSettingsCancelButtonButton'
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    disabled: hasNoChanges,
    isLoading: isLoading,
    onClick: () => setPipeline(defaultPipeline),
    "data-test-subj": 'entSearchContentSettingsResetButton'
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.resetButtonLabel', {
    defaultMessage: 'Reset'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    disabled: hasNoChanges,
    isLoading: isLoading,
    onClick: () => makeRequest(pipelineState),
    "data-test-subj": 'entSearchContentSettingsSaveButton'
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.settings.saveButtonLabel', {
    defaultMessage: 'Save'
  }))))))));
};
exports.DefaultSettingsFlyout = DefaultSettingsFlyout;