"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexOverview = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../shared/doc_links");
var _kibana = require("../../../shared/kibana");
var _indices = require("../../utils/indices");
var _convert_connector_modal = require("../shared/convert_connector_modal/convert_connector_modal");
var _api_total_stats = require("./api_total_stats");
var _convert_connector_logic = require("./connector/native_connector_configuration/convert_connector_logic");
var _connector_total_stats = require("./connector_total_stats");
var _crawl_details_flyout = require("./crawler/crawl_details_flyout/crawl_details_flyout");
var _crawl_requests_panel = require("./crawler/crawl_requests_panel/crawl_requests_panel");
var _crawler_total_stats = require("./crawler_total_stats");
var _generate_api_key_panel = require("./generate_api_key_panel");
var _index_view_logic = require("./index_view_logic");
var _overview = require("./overview.logic");
var _sync_jobs = require("./sync_jobs/sync_jobs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchIndexOverview = () => {
  const {
    indexData
  } = (0, _kea.useValues)(_overview.OverviewLogic);
  const {
    error
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    isCloud
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    showModal
  } = (0, _kea.useActions)(_convert_connector_logic.ConvertConnectorLogic);
  const {
    isModalVisible
  } = (0, _kea.useValues)(_convert_connector_logic.ConvertConnectorLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), (0, _indices.isConnectorIndex)(indexData) && error && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "danger",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.connectorErrorCallOut.title', {
      defaultMessage: 'Your connector has reported an error'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, error)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), (0, _indices.isConnectorIndex)(indexData) && indexData.connector.is_native && !isCloud && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isModalVisible && /*#__PURE__*/_react.default.createElement(_convert_connector_modal.ConvertConnectorModal, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.nativeCloudCallout.title', {
      defaultMessage: 'Native connectors are no longer supported outside Elastic Cloud'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.searchIndex.nativeCloudCallout.content",
    defaultMessage: "Convert it to a {link}, to be self-managed on your own infrastructure. Native connectors are available only in your Elastic Cloud deployment.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "enterpriseSearchSearchIndexOverviewConnectorClientLink",
        href: _doc_links.docLinks.buildConnector,
        target: "_blank"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndex.nativeCloudCallout.connectorClient', {
        defaultMessage: 'connector client'
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchSearchIndexOverviewConvertConnectorButton",
    color: "warning",
    fill: true,
    onClick: () => showModal()
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.searchIndex.convertConnector.buttonLabel', {
    defaultMessage: 'Convert connector'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), (0, _indices.isCrawlerIndex)(indexData) ? /*#__PURE__*/_react.default.createElement(_crawler_total_stats.CrawlerTotalStats, null) : (0, _indices.isConnectorIndex)(indexData) ? /*#__PURE__*/_react.default.createElement(_connector_total_stats.ConnectorTotalStats, null) : /*#__PURE__*/_react.default.createElement(_api_total_stats.ApiTotalStats, null), (0, _indices.isApiIndex)(indexData) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_generate_api_key_panel.GenerateApiKeyPanel, null)), (0, _indices.isCrawlerIndex)(indexData) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_crawl_requests_panel.CrawlRequestsPanel, null), /*#__PURE__*/_react.default.createElement(_crawl_details_flyout.CrawlDetailsFlyout, null)), (0, _indices.isConnectorIndex)(indexData) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_sync_jobs.SyncJobs, {
    errorOnAccessSync: Boolean(indexData.connector.last_access_control_sync_error),
    errorOnContentSync: Boolean(indexData.connector.last_sync_error)
  })));
};
exports.SearchIndexOverview = SearchIndexOverview;