"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlCustomSettingsFlyoutCrawlTypeSelection = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _types = require("../../../../api/crawler/types");
var _crawl_custom_settings_flyout_logic = require("./crawl_custom_settings_flyout_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlCustomSettingsFlyoutCrawlTypeSelection = () => {
  const {
    crawlType
  } = (0, _kea.useValues)(_crawl_custom_settings_flyout_logic.CrawlCustomSettingsFlyoutLogic);
  const {
    onSelectCrawlType
  } = (0, _kea.useActions)(_crawl_custom_settings_flyout_logic.CrawlCustomSettingsFlyoutLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    legend: {
      children: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.crawlTypeGroupLabel', {
        defaultMessage: 'Crawl type'
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    id: _types.CustomCrawlType.ONE_TIME,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.oneTimeCrawlRadioLabel', {
      defaultMessage: 'One-time crawl'
    }),
    checked: crawlType === _types.CustomCrawlType.ONE_TIME,
    onChange: () => onSelectCrawlType(_types.CustomCrawlType.ONE_TIME)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    id: _types.CustomCrawlType.MULTIPLE,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.multipleCrawlsRadioLabel', {
      defaultMessage: 'Multiple crawls'
    }),
    checked: crawlType === _types.CustomCrawlType.MULTIPLE,
    onChange: () => onSelectCrawlType(_types.CustomCrawlType.MULTIPLE)
  }))));
};
exports.CrawlCustomSettingsFlyoutCrawlTypeSelection = CrawlCustomSettingsFlyoutCrawlTypeSelection;