"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchPlaygroundPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../../common/constants");
var _routes = require("../../../../../applications/routes");
var _kibana = require("../../../../../shared/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchPlaygroundPopover = ({
  indexName,
  ingestionMethod
}) => {
  const playgroundUrl = `${_constants.APPLICATIONS_PLUGIN.URL}${_routes.PLAYGROUND_PATH}?default-index=${indexName}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchSearchPlaygroundPopoverViewInPlaygroundButton",
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-header-viewPlayground`,
    iconType: "eye",
    onClick: () => {
      _kibana.KibanaLogic.values.navigateToUrl(playgroundUrl, {
        shouldNotCreateHref: true
      });
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.viewPlayground', {
    defaultMessage: 'View in Playground'
  }));
};
exports.SearchPlaygroundPopover = SearchPlaygroundPopover;