"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorCheckable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../../common/constants");
var _constants2 = require("../../../../shared/constants");
var _platinum_license_popover = require("../../shared/platinum_license_popover/platinum_license_popover");
var _native_popover = require("./native_popover");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCss = (euiTheme, isDisabled, showNativeBadge) => {
  return (0, _react2.css)`
    ${showNativeBadge && `box-shadow: 8px 9px 0px -1px ${euiTheme.colors.lightestShade},
      8px 9px 0px 0px ${euiTheme.colors.lightShade};`}
    ${isDisabled && `background-color: ${euiTheme.colors.lightestShade};
    color: ${euiTheme.colors.disabledText};
    `}
  `;
};
const ConnectorCheckable = ({
  isDisabled,
  documentationUrl,
  iconType,
  isBeta,
  isTechPreview,
  name,
  onConnectorSelect,
  serviceType,
  showNativeBadge,
  showLicensePopover = false,
  showNativePopover = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isLicensePopoverOpen, setIsLicensePopoverOpen] = (0, _react.useState)(false);
  const [isNativeInfoPopoverOpen, setIsNativeInfoPopoverOpen] = (0, _react.useState)(false);
  const [isNativePopoverOpen, setIsNativePopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    onClick: () => {
      if (isDisabled && showNativeBadge) return;
      onConnectorSelect(showNativeBadge);
    },
    id: `checkableCard-${serviceType}`,
    css: getCss(euiTheme, isDisabled || showLicensePopover, showNativeBadge),
    hasBorder: true,
    "data-telemetry-id": `entSearchContent-connector-selectConnector-${serviceType}-select`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, iconType ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    size: "l"
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "flexStart",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "disabledText",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, name)) : /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, name))), !showNativePopover && showLicensePopover && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_platinum_license_popover.PlatinumLicensePopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "entSearchContent-connectors-selectConnector-licensePopoverButton",
      "data-telemetry-id": "entSearchContent-connectors-selectConnector-licensePopoverButton",
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.selectConnector.openPopoverLabel', {
        defaultMessage: 'Open licensing popover'
      }),
      iconType: "questionInCircle",
      onClick: event => {
        event.preventDefault();
        event.stopPropagation();
        setIsLicensePopoverOpen(!isLicensePopoverOpen);
      }
    }),
    closePopover: () => setIsLicensePopoverOpen(false),
    isPopoverOpen: isLicensePopoverOpen
  })), showNativePopover && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_native_popover.NativePopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "entSearchContent-connectors-selectConnector-nativeInfoPopoverButton",
      "data-telemetry-id": "entSearchContent-connectors-selectConnector-nativeInfoPopoverButton",
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.newIndex.selectConnector.openNativePopoverLabel', {
        defaultMessage: 'Open native connector popover'
      }),
      iconType: "questionInCircle",
      onClick: event => {
        event.preventDefault();
        event.stopPropagation();
        setIsNativeInfoPopoverOpen(!isNativeInfoPopoverOpen);
      }
    }),
    closePopover: () => setIsNativeInfoPopoverOpen(false),
    isPopoverOpen: isNativeInfoPopoverOpen
  })))), showNativeBadge && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "entSearchContent-connectors-selectConnector-nativePopoverButton",
      "data-telemetry-id": "entSearchContent-connectors-selectConnector-nativePopoverButton",
      display: "base",
      color: "primary",
      iconType: "boxesHorizontal",
      onClick: e => {
        e.stopPropagation();
        e.preventDefault();
        setIsNativePopoverOpen(true);
      }
    }),
    isOpen: isNativePopoverOpen,
    closePopover: () => {
      setIsNativePopoverOpen(false);
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "xs",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "native",
      disabled: isDisabled,
      onClick: e => {
        e.stopPropagation();
        onConnectorSelect(true);
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.connectorCheckable.setupANativeConnectorContextMenuItemLabel', {
      defaultMessage: 'Setup a Native Connector'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      key: "spacer",
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "client",
      onClick: e => {
        e.stopPropagation();
        onConnectorSelect(false);
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.connectorCheckable.setupAConnectorClientContextMenuItemLabel', {
      defaultMessage: 'Setup a Connector Client'
    }))]
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    justifyContent: "flexStart",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, showNativeBadge ? _constants2.NATIVE_LABEL : _constants2.CONNECTOR_CLIENT_LABEL))), isBeta && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _constants2.BETA_LABEL))), _constants.EXAMPLE_CONNECTOR_SERVICE_TYPES.includes(serviceType) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    iconType: "beaker"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _constants2.EXAMPLE_CONNECTOR_LABEL))), isTechPreview && !_constants.EXAMPLE_CONNECTOR_SERVICE_TYPES.includes(serviceType) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    iconType: "beaker"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.connectorCheckable.techPreviewLabel', {
    defaultMessage: 'Tech preview'
  })))))), documentationUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "entSearchContent-connectors-selectConnector-documentationLink",
    "data-telemetry-id": "entSearchContent-connectors-selectConnector-documentationLink",
    target: "_blank",
    href: documentationUrl
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.connectorCheckable.documentationLinkLabel', {
    defaultMessage: 'Documentation'
  }))))))))));
};
exports.ConnectorCheckable = ConnectorCheckable;