"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NativeConnectorConfiguration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchConnectors = require("@kbn/search-connectors");
var _beta_connector_callout = require("../../../shared/beta/beta_connector_callout");
var _doc_links = require("../../../shared/doc_links");
var _encode_path_params = require("../../../shared/encode_path_params");
var _http = require("../../../shared/http");
var _kibana = require("../../../shared/kibana");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _generate_connector_api_key_api_logic = require("../../api/connector/generate_connector_api_key_api_logic");
var _routes = require("../../routes");
var _has_configured_configuration = require("../../utils/has_configured_configuration");
var _syncs_context_menu = require("../search_index/components/header_actions/syncs_context_menu");
var _api_key_configuration = require("../search_index/connector/api_key_configuration");
var _convert_connector = require("../search_index/connector/native_connector_configuration/convert_connector");
var _native_connector_configuration_config = require("../search_index/connector/native_connector_configuration/native_connector_configuration_config");
var _research_configuration = require("../search_index/connector/native_connector_configuration/research_configuration");
var _attach_index_box = require("./attach_index_box");
var _connector_detail = require("./connector_detail");
var _connector_view_logic = require("./connector_view_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NativeConnectorConfiguration = () => {
  var _connector$service_ty, _connector$features, _connector$features$F, _connector$api_key_id, _nativeConnector$name;
  const {
    connector
  } = (0, _kea.useValues)(_connector_view_logic.ConnectorViewLogic);
  const {
    config,
    connectorTypes: connectors
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    errorConnectingMessage
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    data: apiKeyData
  } = (0, _kea.useValues)(_generate_connector_api_key_api_logic.GenerateConnectorApiKeyApiLogic);
  const NATIVE_CONNECTORS = (0, _react.useMemo)(() => connectors.filter(({
    isNative
  }) => isNative), [connectors]);
  const BETA_CONNECTORS = (0, _react.useMemo)(() => connectors.filter(({
    isBeta
  }) => isBeta), [connectors]);
  if (!connector) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const nativeConnector = NATIVE_CONNECTORS.find(connectorDefinition => connectorDefinition.serviceType === connector.service_type) || {
    docsUrl: '',
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    iconPath: 'custom.svg',
    isBeta: true,
    isNative: true,
    keywords: [],
    name: connector.name,
    serviceType: (_connector$service_ty = connector.service_type) !== null && _connector$service_ty !== void 0 ? _connector$service_ty : ''
  };
  const hasDescription = !!connector.description;
  const hasConfigured = (0, _has_configured_configuration.hasConfiguredConfiguration)(connector.configuration);
  const hasConfiguredAdvanced = connector.last_synced || connector.scheduling.full.enabled || connector.scheduling.incremental.enabled;
  const hasResearched = hasDescription || hasConfigured || hasConfiguredAdvanced;
  const iconPath = nativeConnector.iconPath;
  const hasDocumentLevelSecurity = ((_connector$features = connector.features) === null || _connector$features === void 0 ? void 0 : (_connector$features$F = _connector$features[_searchConnectors.FeatureName.DOCUMENT_LEVEL_SECURITY]) === null || _connector$features$F === void 0 ? void 0 : _connector$features$F.enabled) || false;
  const hasApiKey = !!((_connector$api_key_id = connector.api_key_id) !== null && _connector$api_key_id !== void 0 ? _connector$api_key_id : apiKeyData);

  // TODO service_type === "" is considered unknown/custom connector multipleplaces replace all of them with a better solution
  const isBeta = !connector.service_type || Boolean(BETA_CONNECTORS.find(({
    serviceType
  }) => serviceType === connector.service_type));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "row",
    alignItems: "center"
  }, iconPath && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xl",
    type: iconPath
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, (_nativeConnector$name = nativeConnector === null || nativeConnector === void 0 ? void 0 : nativeConnector.name) !== null && _nativeConnector$name !== void 0 ? _nativeConnector$name : connector.name)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), config.host && config.canDeployEntSearch && errorConnectingMessage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "m",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.entSearchWarning.title', {
      defaultMessage: 'No running Enterprise Search instance detected'
    }),
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.entSearchWarning.text', {
    defaultMessage: 'Native connectors require a running Enterprise Search instance to sync content from source.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_attach_index_box.AttachIndexBox, {
    connector: connector
  })), connector.index_name && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      children: /*#__PURE__*/_react.default.createElement(_research_configuration.ResearchConfiguration, {
        nativeConnector: nativeConnector
      }),
      status: hasResearched ? 'complete' : 'incomplete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.steps.researchConfigurationTitle', {
        defaultMessage: 'Research configuration requirements'
      }),
      titleSize: 'xs'
    }, {
      children: /*#__PURE__*/_react.default.createElement(_native_connector_configuration_config.NativeConnectorConfigurationConfig, {
        connector: connector,
        nativeConnector: nativeConnector,
        status: connector.status
      }),
      status: hasConfigured ? 'complete' : 'incomplete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.steps.configurationTitle', {
        defaultMessage: 'Configuration'
      }),
      titleSize: 'xs'
    }, {
      children: /*#__PURE__*/_react.default.createElement(_api_key_configuration.ApiKeyConfig, {
        indexName: connector.index_name || '',
        hasApiKey: hasApiKey,
        isNative: true
      }),
      status: hasApiKey ? 'complete' : 'incomplete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.steps.manageApiKeyTitle', {
        defaultMessage: 'Manage API key'
      }),
      titleSize: 'xs'
    }, {
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnectorAdvancedConfiguration.description",
        defaultMessage: "Finalize your connector by triggering a one time sync, or setting a recurring sync schedule."
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
        to: `${(0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
          connectorId: connector.id,
          tabId: _connector_detail.ConnectorDetailTabId.SCHEDULING
        })}`
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnectorAdvancedConfiguration.schedulingButtonLabel', {
        defaultMessage: 'Set schedule and sync'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_syncs_context_menu.SyncsContextMenu, null))))),
      status: hasConfiguredAdvanced ? 'complete' : 'incomplete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.steps.advancedConfigurationTitle', {
        defaultMessage: 'Sync your data'
      }),
      titleSize: 'xs'
    }]
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "clock"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.schedulingReminder.title', {
    defaultMessage: 'Configurable sync schedule'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.schedulingReminder.description', {
    defaultMessage: 'Remember to set a sync schedule in the Scheduling tab to continually refresh your searchable data.'
  })))), hasDocumentLevelSecurity && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "globe"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.securityReminder.title', {
    defaultMessage: 'Document level security'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.securityReminder.description', {
    defaultMessage: 'Restrict and personalize the read access users have to the index documents at query time.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "entSearchContent-connectorDetail-documentLevelSecurityLink",
    "data-telemetry-id": "entSearchContent-connectorDetail-documentLevelSecurityLink",
    href: _doc_links.docLinks.documentLevelSecurity,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.securityReminder.securityLinkLabel', {
    defaultMessage: 'Document level security'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_convert_connector.ConvertConnector, null))), isBeta ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_beta_connector_callout.BetaConnectorCallout, null))) : null))));
};
exports.NativeConnectorConfiguration = NativeConnectorConfiguration;