"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorConfiguration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchConnectors = require("@kbn/search-connectors");
var _constants = require("../../../../../common/constants");
var _api = require("../../../../../common/types/api");
var _beta_connector_callout = require("../../../shared/beta/beta_connector_callout");
var _cloud_details = require("../../../shared/cloud_details/cloud_details");
var _doc_links = require("../../../shared/doc_links");
var _encode_path_params = require("../../../shared/encode_path_params");
var _http = require("../../../shared/http");
var _kibana = require("../../../shared/kibana");
var _licensing = require("../../../shared/licensing");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _generate_connector_api_key_api_logic = require("../../api/connector/generate_connector_api_key_api_logic");
var _routes = require("../../routes");
var _connector_status_helpers = require("../../utils/connector_status_helpers");
var _sync_rules_helpers = require("../../utils/sync_rules_helpers");
var _syncs_context_menu = require("../search_index/components/header_actions/syncs_context_menu");
var _api_key_configuration = require("../search_index/connector/api_key_configuration");
var _constants2 = require("../search_index/connector/constants");
var _connector_filtering_logic = require("../search_index/connector/sync_rules/connector_filtering_logic");
var _attach_index_box = require("./attach_index_box");
var _connector_detail = require("./connector_detail");
var _connector_view_logic = require("./connector_view_logic");
var _native_connector_configuration = require("./native_connector_configuration");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorConfiguration = () => {
  var _connector$api_key_id, _connectorTypes$find;
  const {
    data: apiKeyData
  } = (0, _kea.useValues)(_generate_connector_api_key_api_logic.GenerateConnectorApiKeyApiLogic);
  const {
    index,
    isLoading,
    connector,
    updateConnectorConfigurationStatus,
    hasAdvancedFilteringFeature
  } = (0, _kea.useValues)(_connector_view_logic.ConnectorViewLogic);
  const cloudContext = (0, _cloud_details.useCloudDetails)();
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    errorConnectingMessage,
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    advancedSnippet
  } = (0, _kea.useValues)(_connector_filtering_logic.ConnectorFilteringLogic);
  const isAdvancedSnippetEmpty = (0, _sync_rules_helpers.isAdvancedSyncRuleSnippetEmpty)(advancedSnippet);
  const {
    connectorTypes
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const BETA_CONNECTORS = (0, _react.useMemo)(() => connectorTypes.filter(({
    isBeta
  }) => isBeta), [connectorTypes]);
  const {
    fetchConnector,
    updateConnectorConfiguration
  } = (0, _kea.useActions)(_connector_view_logic.ConnectorViewLogic);
  if (!connector) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  if (connector.is_native && connector.service_type) {
    return /*#__PURE__*/_react.default.createElement(_native_connector_configuration.NativeConnectorConfiguration, null);
  }
  const hasApiKey = !!((_connector$api_key_id = connector.api_key_id) !== null && _connector$api_key_id !== void 0 ? _connector$api_key_id : apiKeyData);
  const docsUrl = (_connectorTypes$find = connectorTypes.find(({
    serviceType
  }) => serviceType === connector.service_type)) === null || _connectorTypes$find === void 0 ? void 0 : _connectorTypes$find.docsUrl;
  const isBeta = !connector.service_type || Boolean(BETA_CONNECTORS.find(({
    serviceType
  }) => serviceType === connector.service_type));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null),
  // TODO remove this callout when example status is removed
  connector && connector.service_type && _constants.EXAMPLE_CONNECTOR_SERVICE_TYPES.includes(connector.service_type) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "iInCircle",
    color: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.overview.connectorUnsupportedCallOut.title', {
      defaultMessage: 'Example connector'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.connectors.overview.connectorUnsupportedCallOut.description",
    defaultMessage: "This is an example connector that serves as a building block for customizations. The design and code is being provided as-is with no warranties. This is not subject to the SLA of supported features."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_attach_index_box.AttachIndexBox, {
    connector: connector
  })), connector.index_name && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      children: /*#__PURE__*/_react.default.createElement(_api_key_configuration.ApiKeyConfig, {
        indexName: connector.index_name,
        hasApiKey: !!connector.api_key_id,
        isNative: false
      }),
      status: hasApiKey ? 'complete' : 'incomplete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.generateApiKey.title', {
        defaultMessage: 'Generate an API key'
      }),
      titleSize: 'xs'
    }, {
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.content.connector_detail.configurationConnector.connectorPackage.description.thirdParagraph",
        defaultMessage: "In this step, you will need the API key and connector ID values for your config.yml file. Here's an {exampleLink}.",
        values: {
          exampleLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "entSearchContent-connector-configuration-exampleConfigFileLink",
            "data-telemetry-id": "entSearchContent-connector-configuration-exampleConfigFileLink",
            href: "https://github.com/elastic/connectors-python/blob/main/config.yml.example",
            target: "_blank",
            external: true
          }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.connectorPackage.configurationFileLink', {
            defaultMessage: 'example config file'
          }))
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        fontSize: "m",
        paddingSize: "m",
        color: "dark",
        isCopyable: true
      }, (0, _constants2.getConnectorTemplate)({
        apiKeyData,
        connectorData: {
          id: connector.id,
          service_type: connector.service_type
        },
        host: cloudContext.elasticsearchUrl
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.content.connector_detail.configurationConnector.connectorPackage.description.fourthParagraph",
        defaultMessage: "Because this connector is self-managed, you need to deploy the connector service on your own infrastructure. You can build from source or use Docker. Refer to the {link} for your deployment options.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "entSearchContent-connector-configuration-deploymentModeLink",
            "data-telemetry-id": "entSearchContent-connector-configuration-deploymentModeLink",
            href: _doc_links.docLinks.connectorsClientDeploy,
            target: "_blank",
            external: true
          }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.connectorPackage.deploymentModeLink', {
            defaultMessage: 'documentation'
          }))
        }
      }))),
      status: !connector.status || connector.status === _searchConnectors.ConnectorStatus.CREATED ? 'incomplete' : 'complete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.deployConnector.title', {
        defaultMessage: 'Set up and deploy connector'
      }),
      titleSize: 'xs'
    }, {
      children: /*#__PURE__*/_react.default.createElement(_searchConnectors.ConnectorConfigurationComponent, {
        connector: connector,
        hasPlatinumLicense: hasPlatinumLicense,
        isLoading: updateConnectorConfigurationStatus === _api.Status.LOADING,
        saveConfig: configuration => updateConnectorConfiguration({
          configuration,
          connectorId: connector.id
        }),
        subscriptionLink: _doc_links.docLinks.licenseManagement,
        stackManagementLink: http.basePath.prepend('/app/management/stack/license_management')
      }, !connector.status || connector.status === _searchConnectors.ConnectorStatus.CREATED ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.connectorPackage.waitingForConnectorTitle', {
          defaultMessage: 'Waiting for your connector'
        }),
        iconType: "iInCircle"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.connectorPackage.waitingForConnectorText', {
        defaultMessage: 'Your connector has not connected to Search. Troubleshoot your configuration and refresh the page.'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        disabled: !index,
        "data-test-subj": "entSearchContent-connector-configuration-recheckNow",
        "data-telemetry-id": "entSearchContent-connector-configuration-recheckNow",
        iconType: "refresh",
        onClick: () => fetchConnector({
          connectorId: connector.id
        }),
        isLoading: isLoading
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.connectorPackage.waitingForConnector.button.label', {
        defaultMessage: 'Recheck now'
      }))) : !(0, _connector_status_helpers.isLastSeenOld)(connector) && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        iconType: "check",
        color: "success",
        title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.connectorPackage.connectorConnected', {
          defaultMessage: 'Your connector {name} has connected to Search successfully.',
          values: {
            name: connector.name
          }
        })
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), connector.status && hasAdvancedFilteringFeature && !isAdvancedSnippetEmpty && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.connectorPackage.advancedRulesCallout', {
          defaultMessage: 'Configuration warning'
        }),
        iconType: "iInCircle",
        color: "warning"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.content.connector_detail.configurationConnector.connectorPackage.advancedRulesCallout.description",
        defaultMessage: "{advancedSyncRulesDocs} can override some configuration fields.",
        values: {
          advancedSyncRulesDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "entSearchContent-connector-configuration-advancedSyncRulesDocsLink",
            "data-telemetry-id": "entSearchContent-connector-configuration-advancedSyncRulesDocsLink",
            href: _doc_links.docLinks.syncRules,
            target: "_blank"
          }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.connectorPackage.advancedSyncRulesDocs', {
            defaultMessage: 'Advanced Sync Rules'
          }))
        }
      }))),
      status: connector.status === _searchConnectors.ConnectorStatus.CONNECTED ? 'complete' : 'incomplete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.enhance.title', {
        defaultMessage: 'Configure your connector'
      }),
      titleSize: 'xs'
    }, {
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.scheduleSync.description', {
        defaultMessage: 'Finalize your connector by triggering a one-time sync, or setting a recurring sync to keep your data source in sync over time'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
        "data-test-subj": "entSearchContent-connector-configuration-setScheduleAndSync",
        "data-telemetry-id": "entSearchContent-connector-configuration-setScheduleAndSync",
        isDisabled: (connector === null || connector === void 0 ? void 0 : connector.is_native) && !!errorConnectingMessage || [_searchConnectors.ConnectorStatus.NEEDS_CONFIGURATION, _searchConnectors.ConnectorStatus.CREATED].includes(connector === null || connector === void 0 ? void 0 : connector.status) || !(connector !== null && connector !== void 0 && connector.index_name),
        to: `${(0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
          connectorId: connector.id,
          tabId: _connector_detail.ConnectorDetailTabId.SCHEDULING
        })}`
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.schedule.button.label', {
        defaultMessage: 'Set schedule and sync'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_syncs_context_menu.SyncsContextMenu, null))))),
      status: connector.scheduling.full.enabled ? 'complete' : 'incomplete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.steps.schedule.title', {
        defaultMessage: 'Sync your data'
      }),
      titleSize: 'xs'
    }]
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.support.title', {
    defaultMessage: 'Support and documentation'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.support.description', {
    defaultMessage: 'You need to deploy this connector on your own infrastructure.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "entSearchContent-connector-configuration-connectorDocumentationLink",
    "data-telemetry-id": "entSearchContent-connector-configuration-connectorDocumentationLink",
    href: _doc_links.docLinks.connectors,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.support.viewDocumentation.label', {
    defaultMessage: 'View documentation'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    to: '/app/management/security/api_keys',
    shouldNotCreateHref: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.support.manageKeys.label', {
    defaultMessage: 'Manage API keys'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "entSearchContent-connector-configuration-readmeLink",
    "data-telemetry-id": "entSearchContent-connector-configuration-readmeLink",
    href: "https://github.com/elastic/connectors-python/blob/main/README.md",
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.support.readme.label', {
    defaultMessage: 'Connector readme'
  }))), docsUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "entSearchContent-connector-configuration-deployWithDockerLink",
    "data-telemetry-id": "entSearchContent-connector-configuration-deployWithDockerLink",
    href: docsUrl,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.support.dockerDeploy.label', {
    defaultMessage: 'Deploy with Docker'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "entSearchContent-connector-configuration-deployWithoutDockerLink",
    "data-telemetry-id": "entSearchContent-connector-configuration-deployWithoutDockerLink",
    href: "https://github.com/elastic/connectors-python/blob/main/docs/CONFIG.md#run-the-connector-service-for-a-custom-connector",
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.support.deploy.label', {
    defaultMessage: 'Deploy without Docker'
  })))))), isBeta ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_beta_connector_callout.BetaConnectorCallout, null)) : null))));
};
exports.ConnectorConfiguration = ConnectorConfiguration;