"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchApplicationsPageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _constants = require("../../../../../common/constants");
var _kibana = require("../../../shared/kibana");
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _layout = require("../../../shared/layout");
var _telemetry = require("../../../shared/telemetry");
var _header_docs_action = require("../playground/header_docs_action");
var _header_docs_action2 = require("../search_application/header_docs_action");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnterpriseSearchApplicationsPageTemplate = ({
  children,
  pageChrome,
  pageViewTelemetry,
  searchApplicationName,
  hasSchemaConflicts,
  restrictWidth = true,
  docLink = 'search_application',
  ...pageTemplateProps
}) => {
  const navItems = (0, _layout.useEnterpriseSearchApplicationNav)(searchApplicationName, pageTemplateProps.isEmptyState, hasSchemaConflicts);
  const {
    renderHeaderActions
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  (0, _react.useLayoutEffect)(() => {
    const docAction = {
      playground: _header_docs_action.PlaygroundHeaderDocsAction,
      search_application: _header_docs_action2.SearchApplicationHeaderDocsAction
    }[docLink];
    renderHeaderActions(docAction);
    return () => {
      renderHeaderActions();
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchPageTemplateWrapper, (0, _extends2.default)({}, pageTemplateProps, {
    solutionNav: {
      items: navItems,
      name: _constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.NAME
    },
    restrictWidth: restrictWidth,
    setPageChrome: pageChrome && /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetEnterpriseSearchApplicationsChrome, {
      trail: pageChrome
    }),
    useEndpointHeaderActions: false
  }), pageViewTelemetry && /*#__PURE__*/_react.default.createElement(_telemetry.SendEnterpriseSearchTelemetry, {
    action: "viewed",
    metric: pageViewTelemetry
  }), children);
};
exports.EnterpriseSearchApplicationsPageTemplate = EnterpriseSearchApplicationsPageTemplate;