"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatResult = formatResult;
exports.formatResultWithoutMeta = formatResultWithoutMeta;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isResultMeta(fieldName, _) {
  return fieldName === '_meta';
}
function isFieldValueWrapper(fieldValue) {
  return fieldValue && Object.entries(fieldValue).reduce((isValueWrapper, [k, v]) => {
    if (k !== 'raw' && k !== 'snippet') {
      return false;
    }
    if (v === null) {
      return isValueWrapper;
    }
    return (Array.isArray(v) ? v : [v]).reduce((isScalar, currentValue) => {
      return isScalar && currentValue !== null && typeof currentValue !== 'object';
    }, isValueWrapper);
  }, true);
}
function isNestedFieldValue(fieldValue) {
  if (Array.isArray(fieldValue)) {
    return fieldValue.reduce((isNested, current) => isNested || isNestedFieldValue(current), false);
  }
  return fieldValue != null && typeof fieldValue === 'object' && !isFieldValueWrapper(fieldValue);
}
function formatNestedFieldValue(fieldValue) {
  if (Array.isArray(fieldValue)) {
    return fieldValue.map(formatNestedFieldValue);
  }
  if (fieldValue !== null && typeof fieldValue === 'object') {
    return Object.entries(fieldValue).reduce((formattedFieldValue, [nestedFieldName, currentValue]) => {
      return {
        ...formattedFieldValue,
        [nestedFieldName]: isFieldValueWrapper(currentValue) ? currentValue.raw : formatNestedFieldValue(currentValue)
      };
    }, {});
  }
  return fieldValue;
}
function formatResult(result) {
  return Object.entries(result).reduce((acc, [fieldName, fieldValue]) => {
    if (!isResultMeta(fieldName, fieldValue) && isNestedFieldValue(fieldValue)) {
      return {
        ...acc,
        [fieldName]: {
          raw: formatNestedFieldValue(fieldValue)
        }
      };
    }
    return {
      ...acc,
      [fieldName]: fieldValue
    };
  }, {});
}
function formatResultWithoutMeta(result) {
  return Object.entries(result).reduce((acc, [fieldName, fieldValue]) => {
    if (isResultMeta(fieldName, fieldValue)) {
      return {
        ...acc
      };
    }
    if (isNestedFieldValue(fieldValue)) {
      return {
        ...acc,
        [fieldName]: {
          raw: formatNestedFieldValue(fieldValue)
        }
      };
    }
    return {
      ...acc,
      [fieldName]: fieldValue
    };
  }, {});
}