"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddSourceEnginesButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("../i18n");
var _source_engines_logic = require("../source_engines_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddSourceEnginesButton = () => {
  const {
    openModal
  } = (0, _kea.useActions)(_source_engines_logic.SourceEnginesLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    onClick: openModal
  }, _i18n.ADD_SOURCE_ENGINES_BUTTON_LABEL);
};
exports.AddSourceEnginesButton = AddSourceEnginesButton;