"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.URL_FIELD_LABEL = exports.URL_FIELD_HELP_TEXT = exports.TITLE_FIELD_LABEL = exports.TITLE_FIELD_HELP_TEXT = exports.THUMBNAIL_FIELD_LABEL = exports.THUMBNAIL_FIELD_HELP_TEXT = exports.SORT_FIELD_LABEL = exports.SORT_FIELD_HELP_TEXT = exports.SEARCH_UI_TITLE = exports.NO_SEARCH_KEY_ERROR = exports.GENERATE_PREVIEW_BUTTON_LABEL = exports.FILTER_FIELD_LABEL = exports.FILTER_FIELD_HELP_TEXT = void 0;
var _i18n = require("@kbn/i18n");
var _credentials = require("../credentials");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEARCH_UI_TITLE = exports.SEARCH_UI_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.title', {
  defaultMessage: 'Search UI'
});
const TITLE_FIELD_LABEL = exports.TITLE_FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.titleFieldLabel', {
  defaultMessage: 'Title field (Optional)'
});
const TITLE_FIELD_HELP_TEXT = exports.TITLE_FIELD_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.titleFieldHelpText', {
  defaultMessage: 'Used as the top-level visual identifier for every rendered result'
});
const FILTER_FIELD_LABEL = exports.FILTER_FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.filterFieldLabel', {
  defaultMessage: 'Filter fields (Optional)'
});
const FILTER_FIELD_HELP_TEXT = exports.FILTER_FIELD_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.filterFieldHelpText', {
  defaultMessage: 'Faceted values rendered as filters and available as query refinement'
});
const SORT_FIELD_LABEL = exports.SORT_FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.sortFieldLabel', {
  defaultMessage: 'Sort fields (Optional)'
});
const SORT_FIELD_HELP_TEXT = exports.SORT_FIELD_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.sortHelpText', {
  defaultMessage: 'Used to display result sorting options, ascending and descending'
});
const URL_FIELD_LABEL = exports.URL_FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.urlFieldLabel', {
  defaultMessage: 'URL field (Optional)'
});
const THUMBNAIL_FIELD_LABEL = exports.THUMBNAIL_FIELD_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.thumbnailFieldLabel', {
  defaultMessage: 'Thumbnail field (Optional)'
});
const URL_FIELD_HELP_TEXT = exports.URL_FIELD_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.urlFieldHelpText', {
  defaultMessage: "Used as a result's link target, if applicable"
});
const THUMBNAIL_FIELD_HELP_TEXT = exports.THUMBNAIL_FIELD_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.thumbnailFieldHelpText', {
  defaultMessage: 'Provide an image URL to show a thumbnail image'
});
const GENERATE_PREVIEW_BUTTON_LABEL = exports.GENERATE_PREVIEW_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.generatePreviewButtonLabel', {
  defaultMessage: 'Generate search experience'
});
const NO_SEARCH_KEY_ERROR = engineName => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.searchUI.noSearchKeyErrorMessage', {
  defaultMessage: "It looks like you don't have any Public Search Keys with access to the '{engineName}' engine. Please visit the {credentialsTitle} page to set one up.",
  values: {
    engineName,
    credentialsTitle: _credentials.CREDENTIALS_TITLE
  }
});
exports.NO_SEARCH_KEY_ERROR = NO_SEARCH_KEY_ERROR;