"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestedCurationsCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _routes = require("../../../routes");
var _suggestions_callout = require("../../curations/components/suggestions_callout");
var _engine = require("../../engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SuggestedCurationsCallout = () => {
  const {
    engine: {
      adaptive_relevance_suggestions: adaptiveRelevanceSuggestions,
      adaptive_relevance_suggestions_active: adaptiveRelevanceSuggestionsActive
    }
  } = (0, _kea.useValues)(_engine.EngineLogic);
  const pendingCount = adaptiveRelevanceSuggestions === null || adaptiveRelevanceSuggestions === void 0 ? void 0 : adaptiveRelevanceSuggestions.curation.pending;
  if (typeof adaptiveRelevanceSuggestions === 'undefined' || pendingCount === 0 || adaptiveRelevanceSuggestionsActive === false) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_suggestions_callout.SuggestionsCallout, {
    style: {
      marginBottom: '24px'
    },
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.suggestedCurationsCallout.title', {
      defaultMessage: 'New suggested curations to review'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.suggestedCurationsCallout.description', {
      defaultMessage: "Based on your engine's analytics, there are new suggested curations ready to review."
    }),
    buttonTo: (0, _engine.generateEnginePath)(_routes.ENGINE_CURATIONS_PATH),
    lastUpdatedTimestamp: adaptiveRelevanceSuggestions.curation.last_updated
  });
};
exports.SuggestedCurationsCallout = SuggestedCurationsCallout;