"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUPPORTED_LANGUAGES = exports.SANITIZED_NAME_NOTE = exports.ENGINE_CREATION_TITLE = exports.ENGINE_CREATION_SUCCESS_MESSAGE = exports.ENGINE_CREATION_FORM_TITLE = exports.ENGINE_CREATION_FORM_SUBMIT_BUTTON_LABEL = exports.ENGINE_CREATION_FORM_ENGINE_NAME_PLACEHOLDER = exports.ENGINE_CREATION_FORM_ENGINE_NAME_LABEL = exports.ENGINE_CREATION_FORM_ENGINE_LANGUAGE_LABEL = exports.DEFAULT_LANGUAGE = exports.ALLOWED_CHARS_NOTE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_LANGUAGE = exports.DEFAULT_LANGUAGE = 'Universal';
const ENGINE_CREATION_TITLE = exports.ENGINE_CREATION_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.title', {
  defaultMessage: 'Create an engine'
});
const ENGINE_CREATION_FORM_TITLE = exports.ENGINE_CREATION_FORM_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.form.title', {
  defaultMessage: 'Configure your search engine'
});
const ENGINE_CREATION_FORM_ENGINE_NAME_LABEL = exports.ENGINE_CREATION_FORM_ENGINE_NAME_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.form.engineName.label', {
  defaultMessage: 'Engine name'
});
const ALLOWED_CHARS_NOTE = exports.ALLOWED_CHARS_NOTE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.form.engineName.allowedCharactersHelpText', {
  defaultMessage: 'Engine names can only contain lowercase letters, numbers, and hyphens'
});
const SANITIZED_NAME_NOTE = exports.SANITIZED_NAME_NOTE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.form.engineName.sanitizedNameHelpText', {
  defaultMessage: 'Your engine will be named'
});
const ENGINE_CREATION_FORM_ENGINE_NAME_PLACEHOLDER = exports.ENGINE_CREATION_FORM_ENGINE_NAME_PLACEHOLDER = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.form.engineName.placeholder', {
  defaultMessage: 'i.e., my-search-engine'
});
const ENGINE_CREATION_FORM_ENGINE_LANGUAGE_LABEL = exports.ENGINE_CREATION_FORM_ENGINE_LANGUAGE_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.form.engineLanguage.label', {
  defaultMessage: 'Engine language'
});
const ENGINE_CREATION_FORM_SUBMIT_BUTTON_LABEL = exports.ENGINE_CREATION_FORM_SUBMIT_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.form.submitButton.buttonLabel', {
  defaultMessage: 'Create engine'
});
const ENGINE_CREATION_SUCCESS_MESSAGE = name => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.successMessage', {
  defaultMessage: "Engine '{name}' was created",
  values: {
    name
  }
});
exports.ENGINE_CREATION_SUCCESS_MESSAGE = ENGINE_CREATION_SUCCESS_MESSAGE;
const SUPPORTED_LANGUAGES = exports.SUPPORTED_LANGUAGES = [{
  value: 'Universal',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.supportedLanguages.universalDropDownOptionLabel', {
    defaultMessage: 'Universal'
  })
}, {
  text: '—',
  disabled: true
}, {
  value: 'zh',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.supportedLanguages.chineseDropDownOptionLabel', {
    defaultMessage: 'Chinese'
  })
}, {
  value: 'da',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.supportedLanguages.danishDropDownOptionLabel', {
    defaultMessage: 'Danish'
  })
}, {
  value: 'nl',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.supportedLanguages.dutchDropDownOptionLabel', {
    defaultMessage: 'Dutch'
  })
}, {
  value: 'en',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.supportedLanguages.englishDropDownOptionLabel', {
    defaultMessage: 'English'
  })
}, {
  value: 'fr',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.supportedLanguages.frenchDropDownOptionLabel', {
    defaultMessage: 'French'
  })
}, {
  value: 'de',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.supportedLanguages.germanDropDownOptionLabel', {
    defaultMessage: 'German'
  })
}, {
  value: 'it',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.supportedLanguages.italianDropDownOptionLabel', {
    defaultMessage: 'Italian'
  })
}, {
  value: 'ja',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.supportedLanguages.japaneseDropDownOptionLabel', {
    defaultMessage: 'Japanese'
  })
}, {
  value: 'ko',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.supportedLanguages.koreanDropDownOptionLabel', {
    defaultMessage: 'Korean'
  })
}, {
  value: 'pt',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.supportedLanguages.portugueseDropDownOptionLabel', {
    defaultMessage: 'Portuguese'
  })
}, {
  value: 'pt-br',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.supportedLanguages.portugueseBrazilDropDownOptionLabel', {
    defaultMessage: 'Portuguese (Brazil)'
  })
}, {
  value: 'ru',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.supportedLanguages.russianDropDownOptionLabel', {
    defaultMessage: 'Russian'
  })
}, {
  value: 'es',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.supportedLanguages.spanishDropDownOptionLabel', {
    defaultMessage: 'Spanish'
  })
}, {
  value: 'th',
  text: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.supportedLanguages.thaiDropDownOptionLabel', {
    defaultMessage: 'Thai'
  })
}];