"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EngineRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _flash_messages = require("../../../shared/flash_messages");
var _app_logic = require("../../app_logic");
var _routes = require("../../routes");
var _analytics = require("../analytics");
var _api_logs = require("../api_logs");
var _crawler = require("../crawler");
var _curations = require("../curations");
var _documents = require("../documents");
var _engine_overview = require("../engine_overview");
var _layout = require("../layout");
var _not_found = require("../not_found");
var _relevance_tuning = require("../relevance_tuning");
var _result_settings = require("../result_settings");
var _schema = require("../schema");
var _search_ui = require("../search_ui");
var _source_engines = require("../source_engines");
var _synonyms = require("../synonyms");
var _ = require(".");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EngineRouter = () => {
  const {
    myRole: {
      canViewEngineAnalytics,
      canViewEngineDocuments,
      canViewEngineSchema,
      canViewEngineCrawler,
      canViewMetaEngineSourceEngines,
      canManageEngineRelevanceTuning,
      canManageEngineSynonyms,
      canManageEngineCurations,
      canManageEngineResultSettings,
      canManageEngineSearchUi,
      canViewEngineApiLogs
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    engineName: engineNameFromUrl
  } = (0, _reactRouterDom.useParams)();
  const {
    engineName,
    dataLoading,
    engineNotFound,
    isMetaEngine
  } = (0, _kea.useValues)(_.EngineLogic);
  const {
    setEngineName,
    initializeEngine,
    pollEmptyEngine,
    stopPolling,
    clearEngine
  } = (0, _kea.useActions)(_.EngineLogic);
  (0, _react.useEffect)(() => {
    setEngineName(engineNameFromUrl);
    initializeEngine();
    pollEmptyEngine();
    return () => {
      stopPolling();
      clearEngine();
    };
  }, [engineNameFromUrl]);
  if (engineNotFound) {
    (0, _flash_messages.setQueuedErrorMessage)(_i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.notFound', {
      defaultMessage: "No engine with name '{engineName}' could be found.",
      values: {
        engineName
      }
    }));
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _routes.ENGINES_PATH
    });
  }
  const isLoadingNewEngine = engineName !== engineNameFromUrl;
  if (isLoadingNewEngine || dataLoading) return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    isLoading: true
  });
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ENGINE_PATH
  }, /*#__PURE__*/_react.default.createElement(_engine_overview.EngineOverview, null)), canViewEngineAnalytics && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.ENGINE_ANALYTICS_PATH
  }, /*#__PURE__*/_react.default.createElement(_analytics.AnalyticsRouter, null)), canViewEngineDocuments && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.ENGINE_DOCUMENT_DETAIL_PATH
  }, /*#__PURE__*/_react.default.createElement(_documents.DocumentDetail, null)), canViewEngineDocuments && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.ENGINE_DOCUMENTS_PATH
  }, /*#__PURE__*/_react.default.createElement(_documents.Documents, null)), canViewEngineSchema && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.ENGINE_SCHEMA_PATH
  }, /*#__PURE__*/_react.default.createElement(_schema.SchemaRouter, null)), canViewMetaEngineSourceEngines && isMetaEngine && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.META_ENGINE_SOURCE_ENGINES_PATH
  }, /*#__PURE__*/_react.default.createElement(_source_engines.SourceEngines, null)), canViewEngineCrawler && !isMetaEngine && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.ENGINE_CRAWLER_PATH
  }, /*#__PURE__*/_react.default.createElement(_crawler.CrawlerRouter, null)), canManageEngineRelevanceTuning && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.ENGINE_RELEVANCE_TUNING_PATH
  }, /*#__PURE__*/_react.default.createElement(_relevance_tuning.RelevanceTuning, null)), canManageEngineSynonyms && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.ENGINE_SYNONYMS_PATH
  }, /*#__PURE__*/_react.default.createElement(_synonyms.Synonyms, null)), canManageEngineCurations && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.ENGINE_CURATIONS_PATH
  }, /*#__PURE__*/_react.default.createElement(_curations.CurationsRouter, null)), canManageEngineResultSettings && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.ENGINE_RESULT_SETTINGS_PATH
  }, /*#__PURE__*/_react.default.createElement(_result_settings.ResultSettings, null)), canManageEngineSearchUi && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.ENGINE_SEARCH_UI_PATH
  }, /*#__PURE__*/_react.default.createElement(_search_ui.SearchUI, null)), canViewEngineApiLogs && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.ENGINE_API_LOGS_PATH
  }, /*#__PURE__*/_react.default.createElement(_api_logs.ApiLogs, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_not_found.NotFound, {
    pageChrome: (0, _.getEngineBreadcrumbs)()
  })));
};
exports.EngineRouter = EngineRouter;