"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummarySectionEmpty = exports.SummarySectionAccordion = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
require("./summary_section.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ICON_PROPS = {
  error: {
    type: 'error',
    color: 'danger'
  },
  success: {
    type: 'checkInCircleFilled',
    color: 'success'
  },
  info: {
    type: 'iInCircle',
    color: 'default'
  }
};
const SummarySectionAccordion = ({
  id,
  status,
  title,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: id,
    className: "documentCreationSummarySection",
    arrowDisplay: "right",
    paddingSize: "m",
    buttonContent: /*#__PURE__*/_react.default.createElement("div", {
      className: "documentCreationSummarySection__title"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: ICON_PROPS[status].type,
      color: ICON_PROPS[status].color
    }), title)
  }, children);
};
exports.SummarySectionAccordion = SummarySectionAccordion;
const SummarySectionEmpty = ({
  title
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "documentCreationSummarySection"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "documentCreationSummarySection__title"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, ICON_PROPS.info), title));
};
exports.SummarySectionEmpty = SummarySectionEmpty;