"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IgnoredQueriesPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _table_pagination = require("../../../../../../../shared/table_pagination");
var _data_panel = require("../../../../../data_panel");
var _ignored_queries_logic = require("./ignored_queries_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IgnoredQueriesPanel = () => {
  const {
    dataLoading,
    ignoredQueries,
    meta
  } = (0, _kea.useValues)(_ignored_queries_logic.IgnoredQueriesLogic);
  const {
    allowIgnoredQuery,
    loadIgnoredQueries,
    onPaginate
  } = (0, _kea.useActions)(_ignored_queries_logic.IgnoredQueriesLogic);
  (0, _react.useEffect)(() => {
    loadIgnoredQueries();
  }, [meta.page.current]);

  // @ts-expect-error - EuiBasicTable wants an array of objects, but will accept strings if coerced
  const columns = [{
    render: query => query,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.curations.ignoredSuggestionsPanel.queryColumnName', {
      defaultMessage: 'Query'
    })
  }, {
    actions: [{
      type: 'button',
      name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.curations.ignoredSuggestions.allowButtonLabel', {
        defaultMessage: 'Allow'
      }),
      description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.curations.ignoredSuggestions.allowButtonDescription', {
        defaultMessage: 'Enable suggestions for this query'
      }),
      onClick: query => allowIgnoredQuery(query),
      color: 'primary'
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    isLoading: dataLoading,
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      component: "h2"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.curations.ignoredSuggestionsPanel.title', {
      defaultMessage: 'Ignored queries'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      component: "span",
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "refresh",
      size: "xs",
      onClick: () => loadIgnoredQueries()
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.curations.ignoredSuggestionsPanel.refresh', {
      defaultMessage: 'Refresh'
    })))),
    subtitle: /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.curations.ignoredSuggestionsPanel.description', {
      defaultMessage: 'You won’t be notified about suggestions for these queries'
    })),
    iconType: "eyeClosed",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable
  // @ts-expect-error - EuiBasicTable wants an array of objects, but will accept strings if coerced
  , {
    items: ignoredQueries,
    itemId: "query"
    // @ts-expect-error - EuiBasicTable wants an array of objects, but will accept strings if coerced
    ,
    columns: columns,
    hasActions: true,
    pagination: {
      ...(0, _table_pagination.convertMetaToPagination)(meta),
      showPerPageOptions: false
    },
    onChange: (0, _table_pagination.handlePageChange)(onPaginate)
  }));
};
exports.IgnoredQueriesPanel = IgnoredQueriesPanel;