"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReactEmbeddableRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _public = require("@kbn/presentation-panel-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _uuid = require("uuid");
var _react_embeddable_registry = require("./react_embeddable_registry");
var _react_embeddable_unsaved_changes = require("./react_embeddable_unsaved_changes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ON_STATE_CHANGE_DEBOUNCE = 100;

/**
 * Renders a component from the React Embeddable registry into a Presentation Panel.
 *
 * TODO: Rename this to simply `Embeddable` when the legacy Embeddable system is removed.
 */
const ReactEmbeddableRenderer = ({
  maybeId,
  type,
  state,
  parentApi,
  onApiAvailable,
  panelProps,
  onAnyStateChange
}) => {
  const cleanupFunction = (0, _react.useRef)(null);
  const componentPromise = (0, _react.useMemo)(() => (async () => {
    const uuid = maybeId !== null && maybeId !== void 0 ? maybeId : (0, _uuid.v4)();
    const factory = await (0, _react_embeddable_registry.getReactEmbeddableFactory)(type);
    const registerApi = (apiRegistration, comparators) => {
      const {
        unsavedChanges,
        resetUnsavedChanges,
        cleanup
      } = (0, _react_embeddable_unsaved_changes.startTrackingEmbeddableUnsavedChanges)(uuid, parentApi, comparators, factory.deserializeState);
      if (onAnyStateChange) {
        /**
         * To avoid unnecessary re-renders, only subscribe to the comparator publishing subjects if
         * an `onAnyStateChange` callback is provided
         */
        const comparatorDefinitions = Object.values(comparators);
        (0, _rxjs.combineLatest)(comparatorDefinitions.map(comparator => comparator[0])).pipe((0, _rxjs.skip)(1), (0, _rxjs.debounceTime)(ON_STATE_CHANGE_DEBOUNCE)).subscribe(() => {
          onAnyStateChange(apiRegistration.serializeState());
        });
      }
      const fullApi = {
        ...apiRegistration,
        uuid,
        parentApi,
        unsavedChanges,
        resetUnsavedChanges,
        type: factory.type
      };
      cleanupFunction.current = () => cleanup();
      onApiAvailable === null || onApiAvailable === void 0 ? void 0 : onApiAvailable(fullApi);
      return fullApi;
    };
    const {
      api,
      Component
    } = await factory.buildEmbeddable(factory.deserializeState(state), registerApi, uuid, parentApi);
    return /*#__PURE__*/_react.default.forwardRef((_, ref) => {
      // expose the api into the imperative handle
      (0, _react.useImperativeHandle)(ref, () => api, []);
      return /*#__PURE__*/_react.default.createElement(Component, null);
    });
  })(),
  /**
   * Disabling exhaustive deps because we do not want to re-fetch the component
   * from the embeddable registry unless the type changes.
   */
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [type]);
  (0, _react.useEffect)(() => {
    return () => {
      var _cleanupFunction$curr;
      (_cleanupFunction$curr = cleanupFunction.current) === null || _cleanupFunction$curr === void 0 ? void 0 : _cleanupFunction$curr.call(cleanupFunction);
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_public.PresentationPanel, (0, _extends2.default)({}, panelProps, {
    Component: componentPromise
  }));
};
exports.ReactEmbeddableRenderer = ReactEmbeddableRenderer;