"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContactCardExportableEmbeddableFactory = exports.CONTACT_CARD_EXPORTABLE_EMBEDDABLE = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _contact_card_exportable_embeddable = require("./contact_card_exportable_embeddable");
var _contact_card_initializer = require("./contact_card_initializer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CONTACT_CARD_EXPORTABLE_EMBEDDABLE = exports.CONTACT_CARD_EXPORTABLE_EMBEDDABLE = 'CONTACT_CARD_EXPORTABLE_EMBEDDABLE';
class ContactCardExportableEmbeddableFactory {
  constructor(execTrigger, overlays) {
    (0, _defineProperty2.default)(this, "type", CONTACT_CARD_EXPORTABLE_EMBEDDABLE);
    (0, _defineProperty2.default)(this, "getExplicitInput", () => {
      return new Promise(resolve => {
        const modalSession = this.overlays.openModal((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_contact_card_initializer.ContactCardInitializer, {
          onCancel: () => {
            modalSession.close();
            // @ts-expect-error
            resolve(undefined);
          },
          onCreate: input => {
            modalSession.close();
            resolve(input);
          }
        })), {
          'data-test-subj': 'createContactCardEmbeddable'
        });
      });
    });
    (0, _defineProperty2.default)(this, "create", async (initialInput, parent) => {
      return new _contact_card_exportable_embeddable.ContactCardExportableEmbeddable(initialInput, {
        execAction: this.execTrigger
      }, parent);
    });
    this.execTrigger = execTrigger;
    this.overlays = overlays;
  }
  async isEditable() {
    return true;
  }
  getDefaultInput() {
    return {};
  }
  getDisplayName() {
    return _i18n.i18n.translate('embeddableApi.samples.contactCard.displayName', {
      defaultMessage: 'contact card'
    });
  }
}
exports.ContactCardExportableEmbeddableFactory = ContactCardExportableEmbeddableFactory;