"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withEmbeddableSubscription = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var Rx = _interopRequireWildcard(require("rxjs"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const withEmbeddableSubscription = WrappedComponent => class WithEmbeddableSubscription extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "subscription", void 0);
    (0, _defineProperty2.default)(this, "mounted", false);
    this.state = {
      input: this.props.embeddable.getInput(),
      output: this.props.embeddable.getOutput()
    };
  }
  componentDidMount() {
    this.mounted = true;
    this.subscription = Rx.merge(this.props.embeddable.getOutput$(), this.props.embeddable.getInput$()).subscribe(() => {
      if (this.mounted) {
        this.setState({
          input: this.props.embeddable.getInput(),
          output: this.props.embeddable.getOutput()
        });
      }
    });
  }
  componentWillUnmount() {
    this.mounted = false;
    if (this.subscription) {
      this.subscription.unsubscribe();
    }
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(WrappedComponent, (0, _extends2.default)({
      input: this.state.input,
      output: this.state.output
    }, this.props));
  }
};
exports.withEmbeddableSubscription = withEmbeddableSubscription;