"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddablePanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = require("@emotion/react");
var _public = require("@kbn/presentation-panel-plugin/public");
var _std = require("@kbn/std");
var _react2 = _interopRequireWildcard(require("react"));
var _kibana_services = require("../kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getComponentFromEmbeddable = async (embeddable, isMounted) => {
  const startServicesPromise = (0, _kibana_services.untilPluginStartServicesReady)();
  const embeddablePromise = typeof embeddable === 'function' ? embeddable() : Promise.resolve(embeddable);
  const [, unwrappedEmbeddable] = await Promise.all([startServicesPromise, embeddablePromise]);
  if (!isMounted()) {
    return null;
  }
  if (unwrappedEmbeddable.parent) {
    await unwrappedEmbeddable.parent.untilEmbeddableLoaded(unwrappedEmbeddable.id);
  }
  return /*#__PURE__*/_react2.default.forwardRef((props, apiRef) => {
    const [node, setNode] = (0, _react2.useState)();
    const embeddableRoot = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createRef(), []);

    // Render legacy embeddable into ref, and destroy on unmount.
    (0, _react2.useEffect)(() => {
      var _unwrappedEmbeddable$;
      if (!embeddableRoot.current) return;
      const nextNode = (_unwrappedEmbeddable$ = unwrappedEmbeddable.render(embeddableRoot.current)) !== null && _unwrappedEmbeddable$ !== void 0 ? _unwrappedEmbeddable$ : undefined;
      if ((0, _std.isPromise)(nextNode)) {
        nextNode.then(resolved => setNode(resolved));
      } else {
        setNode(nextNode);
      }
      return () => {
        unwrappedEmbeddable.destroy();
      };
    }, [embeddableRoot]);
    (0, _react2.useImperativeHandle)(apiRef, () => unwrappedEmbeddable);
    return /*#__PURE__*/_react2.default.createElement("div", {
      css: (0, _react.css)(`width: 100%; height: 100%; display:flex`),
      ref: embeddableRoot
    }, node);
  });
};

/**
 * Loads and renders a legacy embeddable.
 *
 * Ancestry chain must use 'key' attribute to reset DOM and state when embeddable changes
 * For example <Parent key={embeddableId}><EmbeddablePanel/></Parent>
 */
const EmbeddablePanel = props => {
  // can not use useMountedState
  // 1. useMountedState defaults mountedRef to false and sets mountedRef to true in useEffect
  // 2. embeddable can be an object or a function that returns a promise
  // 3. when embeddable is an object, Promise.resolve(embeddable) returns before
  //    useMountedState useEffect is called and thus isMounted() returns false when component has not been unmounted
  const mountedRef = (0, _react2.useRef)(true);
  (0, _react2.useEffect)(() => {
    return () => {
      mountedRef.current = false;
    };
  }, []);
  const isMounted = () => {
    return mountedRef.current;
  };
  const {
    embeddable,
    ...passThroughProps
  } = props;
  const componentPromise = (0, _react2.useMemo)(() => getComponentFromEmbeddable(embeddable, isMounted),
  // Ancestry chain is expected to use 'key' attribute to reset DOM and state
  // when embeddable needs to be re-loaded
  // empty array is consistent with PresentationPanel useAsync dependency check
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  return /*#__PURE__*/_react2.default.createElement(_public.PresentationPanel, (0, _extends2.default)({}, passThroughProps, {
    Component: componentPromise
  }));
};
exports.EmbeddablePanel = EmbeddablePanel;